<?php

namespace App\Observers;

use App\Jobs\Notifications\SendNotificationReadyPaymentJob;
use Illuminate\Support\Carbon;
use App\Models\Billings\Invoice;
use App\Services\Billings\ExportInvoiceService;
use Illuminate\Support\Facades\Log;
use App\Services\WhatsappGateway\WhatsappNotificationService;

class InvoiceObserver
{
    protected $whatsappNotificationService, $exportInvoiceService;
    public function __construct(
        WhatsappNotificationService $whatsappNotificationService = null,
        ExportInvoiceService $exportInvoiceService = null
    ) {
        $this->whatsappNotificationService = $whatsappNotificationService ?? new WhatsappNotificationService();
        $this->exportInvoiceService = $exportInvoiceService ?? new ExportInvoiceService();
    }
    /**
     * Handle the CustomerPaket "created" event.
     */
    public function created(Invoice $invoice): void
    {
        $customerPaketBillingAddress = $invoice->customer_paket->customer_billing_address;
        if ($customerPaketBillingAddress?->wa_notification) {
            if ($invoice->total_amount > 0) {
                dispatch(new SendNotificationReadyPaymentJob($invoice))->onQueue('default');
                //$this->whatsappNotificationService->sendInvoiceReadyToPaidNotification($invoice);
            }
        }
    }

    /**
     * Handle the CustomerPaket "updated" event.
     */
    public function updated(Invoice $invoice): void
    {
        $customerPaket = $invoice->customer_paket;
        if ($invoice->isDirty('status') && $invoice->status === 'paid') {
            if ($customerPaket->status != 'active') {
                $customerPaket->forceFill(['status' => 'active']);
            }

            $customerPaket->forceFill([
                'start_date' => $invoice->start_periode,
                'expired_date' => $invoice->end_periode,
                'paylater_date' => null
            ]);
            $customerPaket->save();
            //(new MikrotikPaymentService())->mikrotik_payment_process($customerPaket);
        }

        if ($invoice->isDirty('status') && $invoice->getOriginal('status') === 'paid' && $invoice->status != 'paid') {
            // $customerPaketStatusLatest = $customerPaket->customer_paket_status_latest;
            $expiredDate = $invoice->start_periode;
            $startDate = Carbon::parse($expiredDate)->sub($customerPaket->getRenewalPeriod());

            if (Carbon::parse($expiredDate)->isPast()) {
                $customerPaket->forceFill(['status' => 'expired']);
            }

            $customerPaket->forceFill([
                'start_date' => $startDate,
                'expired_date' => $expiredDate,
            ]);

            $customerPaket->save();
            //(new MikrotikPaymentService())->mikrotik_unpayment_process($customerPaket);
        }
    }

    public function updating(Invoice $invoice)
    {
        //
    }

    /**
     * Handle the CustomerPaket "deleted" event.
     */
    public function deleting(Invoice $invoice): void
    {
        if ($invoice->invoice_path) {
            $this->exportInvoiceService->delete_invoice_file($invoice->invoice_path, 'invoice_files');
        }
    }

    /*
    protected function pruning(Invoice $invoice): void
    {
        $this->exportInvoiceService->delete_invoice_file($invoice->invoice_path, 'invoice_files');
    }*/

    /**
     * Handle the CustomerPaket "restored" event.
     */
    public function restored(Invoice $invoice): void
    {
        //
    }

    /**
     * Handle the CustomerPaket "force deleted" event.
     */
    public function forceDeleted(Invoice $invoice): void
    {
        //
    }
}
