<?php

namespace App\Observers;

use App\Jobs\Notifications\SendNotificationPaymentJob;
use App\Jobs\Notifications\SendNotificationRefundPaymentJob;
use App\Jobs\Notifications\SendNotificationUnpaymentJob;
use App\Models\Billings\Payment;
use App\Services\WhatsappGateway\WhatsappNotificationService;

class PaymentObserver
{
    /**
     * Handle the Payment "created" event.
     */
    public function created(Payment $payment): void
    {
        dispatch(new SendNotificationPaymentJob($payment))->onQueue('default');
        //(new WhatsappNotificationService())->sendPaymentNotification($payment);
    }

    /**
     * Handle the Payment "updated" event.
     */
    public function updated(Payment $payment): void
    {
        $refundedAmount = $payment->refunded_amount - $payment->getOriginal('refunded_amount');
        $customerPaketBillingAddress = $payment->invoice->customer_paket->customer_billing_address;
        if ($customerPaketBillingAddress?->wa_notification) {
            if ($payment->isDirty('refunded_amount') && $payment->refund_status === 'partial') {
                dispatch(new SendNotificationRefundPaymentJob($payment, $refundedAmount, $payment->refunded_bank_account ? $payment->refunded_bank_account : 'cash'))->onQueue('default');
                //(new WhatsappNotificationService())->sendRefundPaymentNotification($payment, $refundedAmount, $payment->refunded_bank_account ? $payment->refunded_bank_account : 'cash');
            } elseif ($payment->isDirty('refunded_amount') && $payment->refund_status === 'full') {
                dispatch(new SendNotificationUnpaymentJob($payment, $refundedAmount))->onQueue('default');
                //(new WhatsappNotificationService())->sendUnpaymentNotification($payment, $refundedAmount);
            }
        }
    }

    /**
     * Handle the Payment "deleted" event.
     */
    public function deleted(Payment $payment): void
    {
        //
    }

    /**
     * Handle the Payment "restored" event.
     */
    public function restored(Payment $payment): void
    {
        //
    }

    /**
     * Handle the Payment "force deleted" event.
     */
    public function forceDeleted(Payment $payment): void
    {
        //
    }
}
