<?php

namespace App\Services\Billings;

use App\Models\Websystem;
use Illuminate\Support\Carbon;
use Barryvdh\DomPDF\Facade\Pdf;
use App\Models\Billings\Invoice;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Webklex\PDFMerger\Facades\PDFMergerFacade as PDFMerger;



class ExportInvoiceService
{

    public function create_invoice_file($invoice)
    {
        $websystem = Websystem::first();
       // $directory = Carbon::parse($invoice->periode)->format('m-Y');
       // Storage::disk('invoice_files')->makeDirectory($directory);
        //$fileName = $fileName . '.pdf';
        $fileName = 'invoice-' . $invoice->invoice_number . '.pdf';

       // $this->delete_invoice_file($directory . '/' . $fileName, 'invoice_files');

        // $path = config('filesystems.disks.local.root');
        $path = config('filesystems.disks.invoice_files.root');
        $pdf = Pdf::loadView('exports.billing.invoice-export', [
            'invoice' => $invoice,
            'system' => $websystem
        ]);

        //$pdf->save($path . '/' . $directory . '/' . $fileName);
         $pdf->save($path . '/' . $fileName);

        return $fileName;
    }

    public function create_invoices_file($customerPakets)
    {
        $customerPaketsId = $customerPakets->pluck('id');
        $invoices = Invoice::where('invoices.status', '!=', 'paid')
            ->whereIn('invoices.customer_paket_id', $customerPaketsId)
            ->join('customer_pakets', 'customer_pakets.id', 'invoices.customer_paket_id')
            ->join('users', 'users.id', 'customer_pakets.user_id')
            ->select(
                DB::raw("CONCAT(users.first_name,' ',COALESCE(users.last_name,'')) as full_name"),
                'invoices.*'
            )
            ->orderBy('full_name', 'ASC')
            ->get();

        $startInvoice = $invoices->sortBy(function ($invoice) {
            return $invoice['periode'];
        })->first();

        $endInvoice = $invoices->sortByDesc(function ($invoice) {
            return $invoice['periode'];
        })->first();

        $fileName = 'invoice-' . Carbon::parse($startInvoice->periode)->format('F-Y') . '-' . Carbon::parse($endInvoice->periode)->format('F-Y') . '.pdf';

        $pathSaveInvoice = config('filesystems.disks.bulk_invoice_files.root');
        $pathInvoiceFiles = config('filesystems.disks.invoice_files.root');

        // Create a new PdfMerger instance
        $oMerger = PDFMerger::init();
        $invoices = $invoices->sortBy(function ($invoice) {
            return $invoice['periode'];
        });

        foreach ($invoices as $invoice) {
            $cekFile = $this->ceckFile(is_null($invoice->invoice_path) ? '-' : $invoice->invoice_path, 'invoice_files');
            if (!$cekFile) {
                $invoicesFile = $this->create_invoice_file($invoice);
                $invoice->forceFill([
                    'invoice_path' => $invoicesFile
                ])->save();
            }
            $oMerger->addPDF($pathInvoiceFiles . '/' . $invoice->invoice_path, 'all');
        }
        // Merge the PDFs
        $oMerger->merge();
        $oMerger->save($pathSaveInvoice . '/' .  $fileName); // Example: download the merged PDF
        return $fileName;
    }

    public function download_file($file, $disk)
    {
        $cekFile = $this->ceckFile($file, $disk);
        if ($cekFile) {
            return Storage::disk($disk)->download($file);
        } else {
            return false;
        }
    }

    public function download_invoice_file($invoice, $disk)
    {
        $cekFile = $this->ceckFile(is_null($invoice->invoice_path) ? '-' : $invoice->invoice_path, $disk);
        if (!$cekFile) {
            $invoicesFile = $this->create_invoice_file($invoice);
            $invoice->forceFill([
                'invoice_path' => $invoicesFile
            ])->save();
        }
        return Storage::disk($disk)->download($invoice->invoice_path);
    }

    public function ceckFile($file, $disk): bool
    {
        if (Storage::disk($disk)->exists($file)) {
            return true;
        } else {
            return false;
        }
    }

    public function delete_invoice_file($file, $disk)
    {
        if ($this->ceckFile($file, $disk)) {
            Storage::disk($disk)->delete($file);
        }
    }
}
