<?php

namespace App\Traits;

use Illuminate\Support\Facades\Cache;

trait AddressCloudAlertTrait
{
    public const PROVINCE = 'https://alamat.thecloudalert.com/api/provinsi/get/';
    public const CITY = 'https://alamat.thecloudalert.com/api/kabkota/get/?d_provinsi_id=';
    public const DISTRICT = 'https://alamat.thecloudalert.com/api/kecamatan/get/?d_kabkota_id=';
    public const SUBDISTRICT = 'https://alamat.thecloudalert.com/api/kelurahan/get/?d_kecamatan_id=';

    public function get_province($cointryID)
    {
        try {
            return Cache::remember('provinces-' . $cointryID, now()->addMonth(), function () {
                return  $this->getAddress(self::PROVINCE);
            });
        } catch (\Exception $e) {
            return ['success' => false];
        }
    }

    public function get_city($provinceId)
    {
        try {
            return Cache::remember('cities-' . $provinceId, now()->addMonth(), function () use ($provinceId) {
                return  $this->getAddress(self::CITY . $provinceId);
            });
        } catch (\Exception $e) {
            return ['success' => false];
        }
    }

    public function get_district($cityId)
    {
        try {
            return  Cache::remember('districts-' . $cityId, now()->addMonth(), function () use ($cityId) {
                return  $this->getAddress(self::DISTRICT . $cityId);
            });
        } catch (\Exception $e) {
            return ['success' => false];
        }
    }

    public function get_subdistrict($districtId)
    {
        try {
            return  Cache::remember('subdistricts-' . $districtId, now()->addMonth(), function () use ($districtId) {
                return   $this->getAddress(self::SUBDISTRICT . $districtId);
            });
        } catch (\Exception $e) {
            return ['success' => false];
        }
    }

    private function getAddress($url)
    {
        $data =  file_get_contents($url);
        return json_decode($data, true);
    }
}
