<?php

namespace App\Traits;

use App\Models\Websystem;
use Illuminate\Support\Carbon;
use App\Models\Customers\CustomerPaket;

trait Billing
{
    public function differentDayCreateInvoice()
    {
        return Websystem::first()->different_day_create_billing;
    }

    public function resetNextBill()
    {
         $customerPakets = CustomerPaket::all();
        foreach ($customerPakets as $customerPaket){
            $customerPaket->forceFill([
                'next_billed_at' => Carbon::parse($customerPaket->start_date)->subDays($this->differentDayCreateInvoice())
            ])->save();
        }
    }
}
