<?php

namespace App\Traits;

use App\Models\Websystem;
use Illuminate\Support\Carbon;
use App\Models\Customers\CustomerPaket;
use App\Models\WhatsappGateway\WhatsappGatewayGeneral;

trait WebSystemTrait
{
    public function subscription_mode()
    {
        return Websystem::first()->subscription_mode;
    }

    public function isPrabayar()
    {
        return Websystem::first()->subscription_mode === 'prabayar' ? true : false;
    }

    public function different_day_create_billing()
    {
        return Websystem::first()->different_day_create_billing;
    }

    // public function is_websystem_mikrotik_auto_isolir_driver()
    //  {
    //      return Websystem::first()->isolir_driver === 'mikrotik' ? true : false;
    //   }

    public function websystem_comment_unpayment()
    {
        return Websystem::first()->comment_unpayment;
    }

    public function websystem_comment_payment()
    {
        return Websystem::first()->comment_payment;
    }

    public function autoIsolirDriverMikrotik()
    {
        return Websystem::first()->isolir_driver === 'mikrotik' ? true : false;
    }

    public function getCompanyName()
    {
        return Websystem::first()->title;
    }

    public function getCompanyAddress()
    {
        $company = Websystem::first();
        $address = $company->address ? $company->address . ', ' : '';
        $subdistrict = $company->subdistrict ? $company->subdistrict . ', ' : '';
        $district = $company->district ? $company->district . ', ' : '';
        $city = $company->city ? $company->city . ', ' : '';
        $province = $company->province ? $company->province . ', ' : '';
        $postalCode = $company->postal_code ? ' - ' . $company->postal_code : '';
        return $address . $subdistrict . $district . $city . $province . $postalCode;
    }

    public function getCompanyPhone()
    {
        $company = Websystem::first();
        if ($company->phone) {
            $country_code = WhatsappGatewayGeneral::first()->country_code;
            return preg_replace('/^' . $country_code . '?/', 0, $company->phone);
        }
        return '';
    }

    public function calculateTax($amount)
    {
        $websystem = Websystem::first();
        $totalTax = $amount * ($websystem->tax_rate / 100);
        return round($totalTax, 2);
    }
}
