<?php

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        try {
            Schema::table('invoice_items', function (Blueprint $table) {
                $table->dropForeign(['invoice_id']);
                $table->uuid('invoice_id')->change();
            });
        } catch (\Exception $e) {
            Schema::table('invoice_items', function (Blueprint $table) {
                $table->uuid('invoice_id')->change();
            });
            Log::error($e->getMessage());
        }

        try {
            Schema::table('orders', function (Blueprint $table) {
                $table->dropForeign(['invoice_id']);
                $table->uuid('invoice_id')->change();
                //$table->dropUnique(['transaction_id']);
            });
        } catch (\Exception $e) {
            Schema::table('orders', function (Blueprint $table) {
                $table->uuid('invoice_id')->change();
            });
            Log::error($e->getMessage());
        }

        try {
            Schema::table('payments', function (Blueprint $table) {
                $table->dropForeign(['invoice_id']);
                $table->uuid('invoice_id')->change();
            });
        } catch (\Exception $e) {
            Schema::table('payments', function (Blueprint $table) {
                $table->uuid('invoice_id')->change();
            });
            Log::error($e->getMessage());
        }

        Schema::table('invoices', function (Blueprint $table) {
            $table->uuid('id')->change();
        });
        DB::statement("ALTER TABLE `invoices` CHANGE `status` `status` ENUM('pending','process','paid','overdue','partially_paid','refunded','failed') NOT NULL DEFAULT 'pending';");

        Schema::table('invoice_items', function (Blueprint $table) {
            $table->foreign('invoice_id')->references('id')->on('invoices')->onDelete('cascade');
        });
        Schema::table('orders', function (Blueprint $table) {
            $table->foreign('invoice_id')->references('id')->on('invoices')->onDelete('cascade');
        });

        Schema::table('payments', function (Blueprint $table) {
            $table->foreign('invoice_id')->references('id')->on('invoices')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('invoices', function (Blueprint $table) {
            //$table->dropColumn('uuid');
        });
    }
};
