<?php

namespace Database\Seeders;


use Illuminate\Database\Seeder;
use App\Models\WhatsappGateway\WhatsappNotificationMessage;

class AddWhatsappNotificationMessageTableSeeder extends Seeder
{

    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $pesan_cancelled_customer_paket = 'Yth. %gender% %name%,
%address%
Customer ID: %customer_id%

Paket anda sudah dibatalkan, kami tidak mengenakan biaya apapun selama proses pembatalan paket.

Info paket:
Paket: *%paket_name%*
Status: *%status%*

%company_name%
%company_address%
%company_phone%

*Pesan ini dikirim otomatis oleh system, anda tidak perlu membalasnya*';

        $pesan_ready_to_paid = 'Yth. %gender% %name%,
%address%
Customer ID: %customer_id%

Saat ini anda sudah bisa melakukan pembayaran layanan internet anda. Anda memiliki %count_bill% tagihan yang belum dibayar:

Info Pembayaran:

%pakets%
*Jumlah tagihan: %total_bill%*

Lokasi Pemasangan: *%installation_address%*
Status: *%status%*

Download %download_invoice%

%company_name%
%company_address%
%company_phone%

*Pesan ini dikirim otomatis oleh system, anda tidak perlu membalasnya*';

        $pesan_refund_payment = 'Yth. %gender% %name%,
%address%
Customer ID: %customer_id%

Pembayaran anda:
Nomor Tagihan: *%invoice_number%*
ID Transaksi: *%transaction_id%*
Jumlah: *%refund_payment%*

Telah dikembalikan ke rekening %customer_bank_account%.

Terima kasih telah menggunakan layanan internet kami.

%company_name%
%company_address%
%company_phone%

*Pesan ini dikirim otomatis oleh system, anda tidak perlu membalasnya*';

        $notif_admin_refund_payment = 'Informasi Pengembalian Pembayaran
Pembayaran customer:
Nama: %name%
Alamat:%address%
Periode: %periode%
Nomor Tagihan: *%invoice_number%*
ID Transaksi: *%transaction_id%*
Jumlah: *%refund_payment%*

Telah dikembalikan ke rekening %customer_bank_account%.

*Pesan ini dikirim otomatis oleh system, anda tidak perlu membalasnya*';

        $notif_admin_connection_status = 'Status Koneksi %connection_status%

Nama: %name%
Email: %email%
Alamat:%address%
Paket: %paket%
Status: %connection_status%
';

        $notificationMessages = collect([
            [
                'slug' => 'cancelled_paket',
                'name' => 'Pembatalan Paket',
                'message' => $pesan_cancelled_customer_paket,
                'description' =>  'Pesan yang dikirim saat paket pelanggan di batalkan.',
                'default' => true,
                'disabled' => false
            ],
            [
                'slug' => 'invoice_ready_to_paid',
                'name' => 'Invoice Ready To Paid',
                'message' => $pesan_ready_to_paid,
                'description' =>  'Pesan yang dikirimkan ke pelanggan saat invoice dibuat.',
                'default' => true,
                'disabled' => false
            ],
            [
                'slug' => 'refund_payment',
                'name' => 'Refund Payment',
                'message' => $pesan_refund_payment,
                'description' =>  'Pesan yang dikirimkan ke pelanggan saat pengembalian pembayaran.',
                'default' => true,
                'disabled' => false
            ],
            [
                'slug' => 'notif_admin_refund_payment',
                'name' => 'Notif Admin Refund Payment',
                'message' => $notif_admin_refund_payment,
                'description' =>  'Pesan yang dikirimkan ke admin saat pengembalian pembayaran.',
                'default' => true,
                'disabled' => false
            ],
            [
                'slug' => 'notif_admin_connection_status',
                'name' => 'Notif Admin Status Koneksi',
                'message' => $notif_admin_connection_status,
                'description' =>  'Pesan yang dikirimkan ke admin saat status koneksi Up/Down.',
                'default' => true,
                'disabled' => false
            ]
        ]);

        //=================Create Template message============================

        foreach($notificationMessages as $notificationMessage){
            if(!WhatsappNotificationMessage::whereSlug($notificationMessage['slug'])->first()){
                WhatsappNotificationMessage::create($notificationMessage);
            }
        }
    }
}
