@props(['heading' => null, 'subheading' => null, 'menu' => null])
<div class="flex max-md:flex-col items-start gap-4 ">
    <div class="w-full md:w-[220px] pb-4 me-10 max-lg:hidden">
        <flux:navlist>
            <flux:navlist.item wire:ignore icon="cog-6-tooth" :href="route('managements.websystem')" :current="request()->routeIs('managements.websystem')" wire:navigate>
                {{trans('menu.general')}}
            </flux:navlist.item>

            <flux:navlist.item wire:ignore icon="user-group" :href="route('managements.users')" :current="request()->routeIs('managements.users')" wire:navigate>
                {{trans('menu.users')}}
            </flux:navlist.item>

            <flux:navlist.item wire:ignore icon="shield-check" :href="route('managements.roles')" :current="request()->routeIs('managements.roles')" wire:navigate>
                {{trans('menu.roles')}}
            </flux:navlist.item>

            <flux:navlist.item wire:ignore icon="server" :href="route('managements.mikrotiks')" :current="request()->routeIs('managements.mikrotiks')" wire:navigate>
                {{trans('menu.servers')}}
            </flux:navlist.item>

            <flux:navlist.item wire:ignore icon="no-symbol" :href="route('managements.autoisolirs')" :current="request()->routeIs('managements.autoisolirs')" wire:navigate>
                {{trans('menu.autoisolirs')}}
            </flux:navlist.item>

            <flux:navlist.item wire:ignore icon="play" :href="route('managements.wanMonitorings')" :current="request()->routeIs('managements.wanMonitorings')" wire:navigate>
                {{trans('menu.wan-monitorings')}}
            </flux:navlist.item>

            <flux:navlist.item wire:ignore icon="rocket-launch" :href="route('managements.webhookMonitorings')" :current="request()->routeIs('managements.webhookMonitorings')" wire:navigate>
                {{trans('menu.webhook-monitorings')}}
            </flux:navlist.item>

            <flux:navlist.item wire:ignore icon="building-library" :href="route('managements.banks')" :current="request()->routeIs('managements.banks')" wire:navigate>
                {{trans('menu.banks')}}
            </flux:navlist.item>
            <flux:navlist.item wire:ignore icon="wa" :href="route('managements.whatsapp_gateway')" :current="request()->routeIs('managements.whatsapp*')" wire:navigate>
                {{ trans('menu.whatsapp-gateway') }}
            </flux:navlist.item>
            <flux:navlist.item wire:ignore icon="wallet" :href="route('managements.paymentgateways')" :current="request()->routeIs('managements.paymentgateways')" wire:navigate>
                {{trans('menu.payment-gateways')}}
            </flux:navlist.item>
            <flux:navlist.item wire:ignore icon="wallet" :href="route('managements.address.list')" :current="request()->routeIs('managements.address.*')" wire:navigate>
                Address
            </flux:navlist.item>
        </flux:navlist>
    </div>

    <div class="flex-1 max-md:pt-6 self-stretch">
        @if($menu)
            <div class="mb-5">
                {{ $menu }}
            </div>
        @endif

        @if($heading)
            <flux:heading >{{ $heading ?? '' }}</flux:heading>
        @endif

        @if($subheading)
            <flux:subheading>{{ $subheading ?? '' }}</flux:subheading>
        @endif

        <div class="w-full max-w-screen">
            {{ $slot }}
        </div>
    </div>
</div>
