@props([
    'sortable' => null,
    'direction' => null,
])

<th
    {{ $attributes->merge(['class' => ''])->only(['class', 'colspan']) }}>

    @unless ($sortable)
        <span class="leading-4 tracking-wider">
            {{ $slot }}
        </span>
    @else
        <button {{ $attributes->except('class') }} class="space-x-1 leading-4">
            <span>
                {{ $slot }}
            </span>
            <span>
                @if ($direction === 'asc')
                    <i class="fas fa-sort-up"></i> ↑
                @elseif ($direction === 'desc')
                    <i class="fas fa-sort-down"></i> ↓
                @else
                    <i class="text-muted fas fa-sort"></i> ↑↓
                @endif
            </span>
        </button>
    @endunless
</th>
