<div>
    @if ($billingSettingModal)
    <flux:modal class="md:w-120 w-[90%]" wire:model="billingSettingModal" :dismissible="false">
        <div class="space-y-6">
            <div>
                <flux:heading size="lg">
                    {{ trans('Setting') }}
                </flux:heading>
            </div>

            <form wire:submit="updateConfiguration" class="space-y-4">

                <div class="grid grid-cols-4 lg:gap-2 gap-1">
                    <div class="place-content-center">
                        <flux:label class="font-semibold">{{ __('websystem.label.different-days-create-invoice') }}</flux:label>
                    </div>
                    <div class="col-span-3">
                        <flux:input wire:model="input.diff_day" type="text" name="diff_day" autocomplete="diff_day"
                            placeholder="{{ __('websystem.placeholder.different-days-create-invoice') }}" />
                    </div>
                </div>

                <div class="grid grid-cols-4 lg:gap-2 gap-1">
                    <div class="place-content-center">
                        <flux:label class="font-semibold">{{ __('websystem.label.subscription-type') }}</flux:label>
                    </div>
                    <div class="co col-span-3">
                        <flux:select wire:model="input.subscription_type" name="subscription_type">
                            <flux:select.option value="prabayar">Pra Bayar</flux:select.option>
                            <flux:select.option value="pascabayar">Pasca Bayar</flux:select.option>
                        </flux:select>

                    </div>
                </div>

                <div class="grid grid-cols-4 lg:gap-2 gap-1">
                    <div class="place-content-center">
                        <flux:label class="font-semibold">{{ __('websystem.label.tax-rate') }}</flux:label>
                    </div>
                    <div class="col-span-3">
                        <flux:input.group>
                            <flux:input wire:model="input.tax_rate" type="text" name="tax_rate" autocomplete="tax_rate"
                                placeholder="{{ __('websystem.placeholder.tax-rate') }}" />
                            <flux:input.group.suffix>%</flux:input.group.suffix>
                        </flux:input.group>
                        <span class="text-gray-500">{{ __('websystem.info.tax-rate') }}</span>
                    </div>
                </div>

                <div class="flex items-center justify-end gap-2">
                    <flux:button wire:click="closeModal()" variant="ghost" class="cursor-pointer">
                        {{ trans('billing.button.cancel') }}
                    </flux:button>

                    <flux:button type="submit" variant="primary" color="green" class="cursor-pointer">
                        {{ __('Save') }}
                    </flux:button>
                </div>
            </form>
        </div>
    </flux:modal>

    @endif
</div>
