<div class="space-y-4">
    <div class="flex justify-end">
        <!--Drop Down-->
        <flux:dropdown align="end">
            <flux:button :icon="request()->routeIs('billings.management.tellers') ? 'user-circle' : 'credit-card' " icon:trailing="chevron-down" class="cursor-pointer">
                {{ request()->routeIs('billings.management.tellers') ? __('Teller Histories') : trans('menu.payment-histories') }}
            </flux:button>
            <flux:menu>
                @if (!request()->routeIs('billings.management.tellers'))
                    <flux:menu.item icon="user-circle" class="cursor-pointer" :href="route('billings.management.tellers')">
                        {{ __('Teller Histories') }}
                    </flux:menu.item>
                @endif

                @if (!request()->routeIs('billings.management.payments'))
                    <flux:menu.item icon="credit-card" class="cursor-pointer" :href="route('billings.management.payments')">
                        {{ trans('menu.payment-histories') }}
                    </flux:menu.item>
                @endif

            </flux:menu>
        </flux:dropdown>
    </div>
    <!-- Date Income -->
    <div class="grid lg:grid-cols-4 gap-4">
        <div class="relative overflow-hidden rounded-xl border border-neutral-200 dark:border-neutral-700">
            @php
                $year = \Carbon\Carbon::now()->format('Y');
                $month = \Carbon\Carbon::now()->format('m');
                $yearPaymnetHistories = \App\Models\Billings\PaymentHistory::where('status', '!=', 'refunded')->whereYear('created_at', $year)->get();

                $yearPayments = $yearPaymnetHistories;
                $monthPayments =$yearPaymnetHistories->filter(function ($paymentHistory) {
                    return \Carbon\Carbon::parse($paymentHistory->created_at)->isSameMonth(\Carbon\Carbon::now());
                });
                $weekPayments = $yearPaymnetHistories->filter(function ($paymentHistory) {
                    return \Carbon\Carbon::parse($paymentHistory->created_at)->isMonday();
                });
                $todayPayments = $yearPaymnetHistories->filter(function ($paymentHistory) {
                    return \Carbon\Carbon::parse($paymentHistory->created_at)->isToday();
                });

                $tellers = $monthPayments->unique('teller_name');
                $users = \app\Models\User::role('admin')->get();
            @endphp
            <div class="p-4">
                <flux:text>Today's income</flux:text>
                <flux:heading size="lg" class="mb-1">@moneyIDR($todayPayments->sum('amount'))</flux:heading>
                <div class="flex items-center gap-2">
                    <flux:icon.calendar-days variant="micro" class="text-green-600 dark:text-green-500" />
                    <span class="text-sm text-green-600 dark:text-green-500">{{ \Carbon\Carbon::now()->format('d F Y') }}</span>
                </div>
            </div>
        </div>

        <div class="relative overflow-hidden rounded-xl border border-neutral-200 dark:border-neutral-700">
            <div class="p-4">
                <flux:text>This week's income</flux:text>
                <flux:heading size="lg" class="mb-1">@moneyIDR($weekPayments->sum('amount'))</flux:heading>
                <div class="flex items-center gap-2">
                    <flux:icon.calendar-days variant="micro" class="text-green-600 dark:text-green-500" />
                    <span class="text-sm text-green-600 dark:text-green-500">{{ \Carbon\Carbon::now()->startOfWeek(\Carbon\Carbon::MONDAY)->format('d M Y') }} - {{ \Carbon\Carbon::now()->endOfWeek(\Carbon\Carbon::MONDAY)->format('d M Y') }}</span>
                </div>
            </div>
        </div>

        <div class="relative overflow-hidden rounded-xl border border-neutral-200 dark:border-neutral-700">
            <div class="p-4">
                <flux:text>This month income</flux:text>
                <flux:heading size="lg" class="mb-1">@moneyIDR($monthPayments->sum('amount'))</flux:heading>
                <div class="flex items-center gap-2">
                    <flux:icon.calendar-days variant="micro" class="text-green-600 dark:text-green-500" />
                    <span class="text-sm text-green-600 dark:text-green-500">{{ \Carbon\Carbon::now()->startOfMonth()->format('d') }} - {{ \Carbon\Carbon::now()->endOfMonth()->format('d F Y') }}</span>
                </div>
            </div>
        </div>

        <div class="relative overflow-hidden rounded-xl border border-neutral-200 dark:border-neutral-700">
            <div class="p-4">
                <flux:text>This year income</flux:text>
                <flux:heading size="lg" class="mb-1">@moneyIDR($yearPayments->sum('amount'))</flux:heading>
                <div class="flex items-center gap-2">
                    <flux:icon.calendar-days variant="micro" class="text-green-600 dark:text-green-500" />
                    <span class="text-sm text-green-600 dark:text-green-500">{{ \Carbon\Carbon::now()->startOfYear()->format('F') }} - {{ \Carbon\Carbon::now()->endOfYear()->format('F Y') }}</span>
                </div>
            </div>
        </div>

    </div>
    <!--Search-->
    <div class="grid lg:grid-cols-6 gap-4">
        @php
            $disable = empty($startDateDeadline) ? false:true;
        @endphp
        <flux:select wire:model.change="search_with_year" :disable="$disable" click="clearSearchWithYear">
            <flux:select.option value="">{{ __('billing.ph.all-year') }}</flux:select.option>
            @foreach (array_reverse(\Carbon\CarbonPeriod::create(now()->subYears(5), '1 year', now())->toArray()) as $date)
                <flux:select.option value="{{ $date->format('Y') }}">
                    {{ $date->format('Y') }}
                </flux:select.option>
            @endforeach
        </flux:select>

        <flux:select wire:model.change="search_with_month" name="search_with_month" :disable="$disable"  click="clearSearchWithMonth">
            <flux:select.option value="">{{ __('billing.ph.all-month') }}</flux:select.option>
            @foreach (array_reverse(\Carbon\CarbonPeriod::create(now()->addMonth(), '1 month', now()->addMonths(12))->toArray()) as $date)
                <flux:select.option value="{{ $date->format('m') }}">
                    {{ $date->format('F') }}
                </flux:select.option>
            @endforeach
        </flux:select>



        <x-input-date-range class="col-span-2" click="clearSearchDateDeadline">
            <x-slot name="start_date" wire:model="startDateDeadline"></x-slot>
            <x-slot name="end_date" wire:model="endDateDeadline"></x-slot>
        </x-input-date-range>

        <flux:select wire:model.change="search_with_teller"  click="clearSearchWithTeller">
            <flux:select.option value="">{{ trans('billing.ph.search-teller') }}</flux:select.option>
            @foreach ($users as $user)
                <flux:select.option value="{{ $user->full_name }}">
                    {{ $user->full_name }}
                </flux:select.option>
            @endforeach
        </flux:select>

        <div class="flex gap-2 justify-between">
            <div class="place-content-center justify-start">
            <flux:button size="sm" wire:click="clearSearch" title="{{ __('Reset') }}" style="cursor: pointer;"
                variant="primary" iconTrailing="arrow-path"/>
            </div>

            <div class="justify-end">
            </div>
        </div>

    </div>

    <div wire:loading.class="opacity-75" class="space-y-2">
        <x-tables.table class="table-fixed">
            <x-slot name="header">
                <x-tables.theader>
                    <x-tables.header class="w-2 text-center">{{ trans('billing.table.no') }}</x-tables.header>
                    <x-tables.header>
                        {{ trans('billing.table.customer-name') }}
                    </x-tables.header>

                    <x-tables.header>
                        {{ trans('billing.table.customer-address') }}
                    </x-tables.header>
                     <x-tables.header>
                        {{ trans('Transaction ID') }}
                    </x-tables.header>

                    <x-tables.header>
                        {{ trans('billing.table.customer-paket') }}
                    </x-tables.header>
                    <x-tables.header>
                        {{ trans('Net Price') }}
                    </x-tables.header>

                    <x-tables.header>
                        {{ trans('billing.table.periode') }}
                    </x-tables.header>
                    <x-tables.header>
                        {{ trans('billing.table.payments') }}
                    </x-tables.header>
                    <x-tables.header>
                        {{ trans('billing.table.teller') }}
                    </x-tables.header>
                    <x-tables.header>
                        {{ trans('billing.table.status') }}
                    </x-tables.header>
                    <x-tables.header>
                        Note
                    </x-tables.header>
                    <x-tables.header>
                        {{ trans('billing.table.payment-time') }}
                    </x-tables.header>
                </x-tables.theader>
            </x-slot>
            <x-slot name="body">
                @forelse ($paymentHistories as $key => $payment)
                    <x-tables.row>
                        <x-tables.cell
                            class="text-center">{{ ($paymentHistories->currentpage() - 1) * $paymentHistories->perpage() + $loop->index + 1 }}</x-tables.cell>
                        <x-tables.cell>
                            {{$payment->customer_name}}
                        </x-tables.cell>
                        <x-tables.cell>
                            {{$payment->customer_address}}
                        </x-tables.cell>
                        <x-tables.cell>
                            {{$payment->transaction_id}}
                        </x-tables.cell>
                        <x-tables.cell>
                            {{$payment->paket_name}}
                        </x-tables.cell>
                        <x-tables.cell>
                            @moneyIDR($payment->net_customer_price)
                        </x-tables.cell>
                        <x-tables.cell>
                            {{$payment->period}}
                        </x-tables.cell>
                        <x-tables.cell>
                            <div class="flex justify-end">
                                @moneyIDR($payment->amount)
                            </div>
                        </x-tables.cell>
                        <x-tables.cell>
                            {{$payment->teller_name}}
                        </x-tables.cell>
                        <x-tables.cell>
                            {{Str::apa($payment->status)}}
                        </x-tables.cell>
                        <x-tables.cell>
                            {{$payment->notes}}
                        </x-tables.cell>
                        <x-tables.cell>
                            {{\Carbon\Carbon::parse($payment->created_at)->format('d-m-Y, h:i a')}}
                        </x-tables.cell>
                    </x-tables.row>
                @empty
                    <x-tables.row>
                        <x-tables.cell colspan=12>
                            <div class="flex justify-center items-center">
                                <span class="font-medium py-8 text-gray-400 text-xl">
                                    {{ trans('Payment not found') }}
                                </span>
                            </div>
                        </x-tables.cell>
                    </x-tables.row>
                @endforelse
            </x-slot>

            <x-slot name="footer">
                <x-tables.row>
                    <x-tables.cell-table-1 colspan=6 class="bg-gray-300 dark:bg-white/10">
                        <div class="justify-end flex text-xs font-semibold">
                            {!! trans('billing.total-payments', ['teller' => empty($search_with_teller) ? 'All Teller': $search_with_teller]) !!}:
                        </div>
                    </x-tables.cell-table-1>
                    <x-tables.cell-table-1 class="bg-gray-300 dark:bg-white/10">
                        <div class="justify-end flex text-xs font-semibold">
                            @moneyIDR($paymentHistories->sum('amount'))
                        </div>
                    </x-tables.cell-table-1>
                    <x-tables.cell-table-1 colspan=5 class="bg-gray-300 dark:bg-white/10"></x-tables.cell-table-1>
                </x-tables.row>
            </x-slot>
        </x-tables.table>
        @if ($paymentHistories->hasPages())
            {{ $paymentHistories->links() }}
        @endif

    </div>

</div>
