<div class="space-y-4">
    <div class="flex justify-end gap-2">
        <flux:select wire:model.change="year">
            @foreach (array_reverse(\Carbon\CarbonPeriod::create(now()->subYears(5), '1 year', now())->toArray()) as $date)
                <flux:select.option value="{{ $date->format('Y') }}">
                    {{ $date->format('Y') }}
                </flux:select.option>
            @endforeach
        </flux:select>
        <!--Drop Down-->
        <flux:dropdown align="end">
            <flux:button :icon="request()->routeIs('billings.management.tellers') ? 'user-circle' : 'credit-card' " icon:trailing="chevron-down" class="cursor-pointer">
                {{ request()->routeIs('billings.management.tellers') ? __('Teller Histories') : trans('menu.payment-histories') }}
            </flux:button>
            <flux:menu>
                @if (!request()->routeIs('billings.management.tellers'))
                    <flux:menu.item icon="user-circle" class="cursor-pointer" :href="route('billings.management.tellers')">
                        {{ __('Teller Histories') }}
                    </flux:menu.item>
                @endif

                @if (!request()->routeIs('billings.management.payments'))
                    <flux:menu.item icon="credit-card" class="cursor-pointer" :href="route('billings.management.payments')">
                        {{ trans('menu.payment-histories') }}
                    </flux:menu.item>
                @endif

            </flux:menu>
        </flux:dropdown>
    </div>

    <div wire:loading.class="opacity-75">
        @php
            $paymentGroupedByMonths = $paymentHistories->groupBy([
                function ($item) {
                    return \Carbon\Carbon::parse($item['created_at'])->format('y-m');
                },
                'teller_name'
            ])->sortBy(function ($item, $key) {
                return $key;
            });
        @endphp
        
        <div class="space-y-6">

            @forelse ( $paymentGroupedByMonths as $month => $paymentGroupedByTellers)
            <div class="space-y-2">
                <flux:heading>{{ \Carbon\Carbon::parse($month.'-01')->format('F Y') }}</flux:heading>
                <x-tables.table class="table-fixed">
                    <x-slot name="header">
                        <x-tables.theader>
                            <x-tables.header class="w-2 text-center">{{ trans('billing.table.no') }}</x-tables.header>
                            <x-tables.header>
                                Name
                            </x-tables.header>
                            <x-tables.header>
                                Cash
                            </x-tables.header>
                            <x-tables.header>
                                Transfer
                            </x-tables.header>
                            <x-tables.header>
                                Amount
                            </x-tables.header>
                        </x-tables.theader>
                    </x-slot>
                    <x-slot name="body">
                        @forelse ( $paymentGroupedByTellers as $teller => $paymentGroupedByTeller)
                            <x-tables.row>
                                <x-tables.cell class="text-center">
                                    {{ $loop->index + 1 }}
                                </x-tables.cell>
                                <x-tables.cell>
                                    {{ $teller }}
                                </x-tables.cell>

                                <x-tables.cell>
                                    <div class="text-right">
                                        @moneyIDR($paymentGroupedByTeller->where('payment_method', 'cash')->sum('amount'))
                                    </div>
                                </x-tables.cell>
                                <x-tables.cell>
                                    @php
                                        $paymentByTransfers = $paymentGroupedByTeller->where('payment_method', '!=', 'cash');
                                        $paymentGroupedByBanks = $paymentByTransfers->groupBy('bank_account')
                                        ->sortBy(function ($item, $key) {
                                            return $key;
                                        });
                                    @endphp
                                   
                                        <div class="space-y-2">
                                            @foreach ($paymentGroupedByBanks as $bank => $paymentGroupedByBank)
                                                <div class="flex justify-between">
                                                    <div class="justify-start">
                                                        {{ $bank }}
                                                    </div>
                                                    <div class="justify-end">
                                                        @moneyIDR($paymentGroupedByBank->sum('amount'))
                                                    </div>
                                                </div>
                                            @endforeach
                                            <div class="flex justify-between font-semibold">
                                                <div class="justify-start">
                                                    Total Amount:
                                                </div>
                                                <div class="justify-end">
                                                   @moneyIDR($paymentByTransfers->sum('amount'))
                                                </div>
                                            </div>
                                        </div>
                                    </x-tables.cell>

                                <x-tables.cell>
                                    <div class="text-right">
                                        @moneyIDR($paymentGroupedByTeller->sum('amount'))
                                    </div>
                                </x-tables.cell>
                            </x-tables.row>
                        @empty
                            <x-tables.row>
                                <x-tables.cell colspan=5>
                                    <div class="flex justify-center items-center">
                                        <span class="font-medium py-8 text-gray-400 text-xl">
                                            {{ trans('Payment History not found') }}
                                        </span>
                                    </div>
                                </x-tables.cell>
                            </x-tables.row>
                        @endforelse
                    </x-slot>
                    <x-slot name="footer">
                        <x-tables.row>
                            <x-tables.cell-table-1 colspan=2 class="bg-gray-300 dark:bg-white/10">
                                <div class="text-right font-semibold">
                                    Total:
                                </div>
                            </x-tables.cell-table-1>
                            <x-tables.cell-table-1 class="bg-gray-300 dark:bg-white/10">
                                <div class="justify-end flex text-xs font-semibold">
                                    @php
                                        $totalPaymentHistoriesMonthCash = $paymentHistories->where('payment_method', 'cash')->filter(function ($paymentHistory) use($month) {
                                            return \Carbon\Carbon::parse($paymentHistory->created_at)->isSameMonth(\Carbon\Carbon::parse($month.'-01'));
                                        });
                                    @endphp
                                    @moneyIDR($totalPaymentHistoriesMonthCash->sum('amount'))
                                </div>
                            </x-tables.cell-table-1>
                            <x-tables.cell-table-1 class="bg-gray-300 dark:bg-white/10">
                                @php
                                    $totalPaymentHistoriesMonthTransfer = $paymentHistories->where('payment_method', '!=', 'cash')
                                    ->filter(function ($paymentHistory) use($month) {
                                        return \Carbon\Carbon::parse($paymentHistory->created_at)->isSameMonth(\Carbon\Carbon::parse($month.'-01'));
                                    });

                                    $paymentMonthGroupedByBanks = $totalPaymentHistoriesMonthTransfer->groupBy('bank_account')
                                    ->sortBy(function ($item, $key) {
                                        return $key;
                                    });
                                @endphp

                                <div class="space-y-2">
                                    @foreach ($paymentMonthGroupedByBanks as $bankName => $paymentMonthGroupedByBank)
                                        <div class="flex justify-between">
                                            <div class="justify-start">
                                                {{ $bankName }}
                                            </div>
                                            <div class="justify-end">
                                                @moneyIDR($paymentMonthGroupedByBank->sum('amount'))
                                            </div>
                                        </div>
                                    @endforeach
                                    <div class="flex justify-between font-semibold">
                                        <div class="justify-start">
                                            Total Amount:
                                        </div>
                                        <div class="justify-end">
                                            @moneyIDR($totalPaymentHistoriesMonthTransfer->sum('amount'))
                                        </div>
                                    </div>
                                </div>
                            </x-tables.cell-table-1>
                            <x-tables.cell-table-1 class="bg-gray-300 dark:bg-white/10">
                                <div class="justify-end flex text-xs font-semibold">
                                    @php
                                        $totalPaymentHistoriesMonth = $paymentHistories->filter(function ($paymentHistory) use($month) {
                                            return \Carbon\Carbon::parse($paymentHistory->created_at)->isSameMonth(\Carbon\Carbon::parse($month.'-01'));
                                        });
                                    @endphp
                                    @moneyIDR($totalPaymentHistoriesMonth->sum('amount'))
                                </div>
                            </x-tables.cell-table-1>
                        </x-tables.row>
                    </x-slot>
                </x-tables.table>
            </div>
            @empty

            <x-tables.table class="table-fixed">
                    <x-slot name="header">
                        <x-tables.theader>
                            <x-tables.header class="w-2 text-center">{{ trans('billing.table.no') }}</x-tables.header>
                            <x-tables.header>
                                Name
                            </x-tables.header>
                            <x-tables.header>
                                Amount
                            </x-tables.header>
                        </x-tables.theader>
                    </x-slot>
                    <x-slot name="body">
                        <x-tables.row>
                            <x-tables.cell colspan=3>
                                <div class="flex justify-center items-center">
                                    <span class="font-medium py-8 text-gray-400 text-xl">
                                        {{ trans('Payment history not found') }}
                                    </span>
                                </div>
                            </x-tables.cell>
                        </x-tables.row>
                    </x-slot>
                </x-tables.table>

            @endforelse
        </div>
    </div>
</div>
