<div class="flex gap-2 flex-col">
    <div class="relative mb-6 space-y-6 w-full">
        <div class="space-y-4">
            <div class="flex justify-between gap-2">
                <div class="justify-start">
                    <flux:heading size="xl" level="1">{{ __('Payment Detail') }}</flux:heading>
                </div>
                <div class="justify-end">
                    <flux:button size="sm" variant="primary" color="green" icon="arrow-left-circle" :href="route('billings.management')">
                        Billings
                    </flux:button>
                </div>
            </div>

            <div class="">
                <flux:heading size="xl" level="1">
                    <flux:link :href="route('customer.show', $invoice->customer_paket->user->username)" wire:navigate>
                        {{ $invoice->customer_paket->user->full_name }}
                    </flux:link>
                </flux:heading>
                <flux:text>
                    {{ trans('customer.label.address') }}: {{ $invoice->customer_paket->full_customer_billing_address }}
                </flux:text>
                <flux:text>
                    {{ trans('customer.label.email') }}: {{ $user->email ?? '-' }}
                </flux:text>
                <flux:text class="mb-3">
                    {{ trans('customer.label.phone') }}: {{ $invoice->customer_paket->customer_billing_address->phone ?? '-' }}
                </flux:text>
            </div>
        </div>
        <flux:separator variant="subtle"/>
    </div>


    <div wire:loading.class="opacity-75">

        <x-tables.table class="table-fixed">
            <x-slot name="header">
                <x-tables.theader>
                    <x-tables.header class="w-2 text-center">{{ trans('billing.table.no') }}</x-tables.header>
                    <x-tables.header class="w-max">{{ trans('Invoice Number') }}</x-tables.header>
                    <x-tables.header class="w-max">{{ trans('Transaction ID') }}</x-tables.header>
                    <x-tables.header class="w-max">{{ trans('Amount') }}</x-tables.header>
                    <x-tables.header class="w-max">{{ trans('Refund') }}</x-tables.header>
                    <x-tables.header class="w-max">{{ trans('Recontiliation') }}</x-tables.header>
                    <x-tables.header class="w-max">{{ trans('Method') }}</x-tables.header>
                    <x-tables.header class="w-max">{{ trans('Teller') }}</x-tables.header>
                    <x-tables.header class="w-max">Note</x-tables.header>
                    <x-tables.header>
                        {{ trans('billing.table.action') }}
                    </x-tables.header>
                </x-tables.theader>
            </x-slot>
            <x-slot name="body">
                @forelse ($payments as $key => $payment)
                    <x-tables.row>
                        <x-tables.cell
                            class="text-center">{{ ($payments->currentpage() - 1) * $payments->perpage() + $loop->index + 1 }}
                        </x-tables.cell>
                        <x-tables.cell>
                            {{ $this->invoice->invoice_number }}
                        </x-tables.cell>
                        <x-tables.cell>
                            {{ $payment->transaction_id }}
                        </x-tables.cell>
                        <x-tables.cell>
                            @moneyIDR($payment->amount)
                        </x-tables.cell>
                        <x-tables.cell>
                            @moneyIDR($payment->refunded_amount) - {{ $payment->refund_status }}
                        </x-tables.cell>
                        <x-tables.cell>
                           {{$payment->reconciliation_status}} @if($payment->reconciliation_notes)- {{$payment->reconciliation_notes}}@endif
                        </x-tables.cell>
                        <x-tables.cell>
                            {{ $payment->payment_method }} @if ($payment->bank) - {{ $payment->bank }}@endif
                        </x-tables.cell>
                        <x-tables.cell>
                            {{ $payment->teller }}
                        </x-tables.cell>
                        <x-tables.cell>
                            {{ $payment->notes }}
                        </x-tables.cell>

                        <x-tables.cell>

                            @if ($payment->remaining_refundable_amount > 0)
                                <flux:tooltip content="{{ __('billing.button.refund') }}">
                                    <flux:button size="xs"
                                        wire:click="$dispatch('billing-refund-modal', {payment: '{{ $payment->id }}'})"
                                        variant="primary" color="red" class="cursor-pointer"
                                        icon="arrow-uturn-left">
                                        {{ __('billing.button.refund') }}
                                    </flux:button>
                                </flux:tooltip>
                            @endif
                        </x-tables.cell>

                    </x-tables.row>
                @empty
                    <x-tables.row>
                        <x-tables.cell colspan=10>
                            <div class="flex justify-center items-center">
                                <span class="font-medium py-8 text-gray-400 text-xl">
                                    {{ trans('Payment not found') }}
                                </span>
                            </div>
                        </x-tables.cell>
                    </x-tables.row>
                @endforelse

            </x-slot>
        </x-tables.table>

        @if ($payments->hasPages())
            <div class="p-3">
                {{ $payments->links() }}
            </div>
        @endif
    </div>

    <livewire:admin.billings.modal.billing-payment />
    <livewire:admin.billings.modal.send-notifications />
    <livewire:admin.billings.modal.delete-invoice />
    <livewire:admin.billings.modal.billing-refund />
</div>
