<div>
     @php
        $userDeleted = App\Models\User::whereHas('user_customer', function ($user_customer) {
            $user_customer->onlyTrashed();
        })->onlyTrashed();
        $deletedCustomerPakets = App\Models\Customers\CustomerPaket::whereHas('user')->whereHas('paket')->onlyTrashed();
        $whatsappGatewayDisabled = \App\Models\WhatsappGateway\WhatsappGatewayGeneral::first()->disabled;
    @endphp
    <div class="relative mb-6 w-full">
        <div class="flex flex-col md:flex-row justify-between gap-2 mb-6">
            <div class="flex flex-col md:flex-row justify-start gap-2">
                <flux:heading size="xl" level="1">{{ __('Customer Pakets') }}</flux:heading>
            </div>
            <div class="flex flex-col md:flex-row justify-between">
                <!--Drop Down-->
                <flux:dropdown align="end">
                    <flux:button icon:trailing="chevron-down" class="cursor-pointer">Options</flux:button>
                    <flux:menu>
                        @if (!$whatsappGatewayDisabled)
                            <flux:menu.item icon="wa" wire:click="$dispatch('show-send-message-all-customer-paket-modal')" class="cursor-pointer">
                                {{ __('Send Message') }}
                            </flux:menu.item>
                            <flux:menu.separator />
                        @endif
                         @if($deletedCustomerPakets->count())
                            <flux:menu.item variant="danger" icon="trash" :href="route('deletedCustomers.paket.management')" wire:navigate class="cursor-pointer">
                                {{ __('customer.button.deleted-customer-pakets',['count' => $deletedCustomerPakets->count()]) }}
                            </flux:menu.item>
                            <flux:menu.separator />
                         @endif

                        <flux:menu.item icon="information-circle" class="cursor-pointer" :href="route('helps.customers.customer')" target="_blank">
                            {{ __('user.button.help') }}
                        </flux:menu.item>
                    </flux:menu>
                </flux:dropdown>

             </div>
        </div>
        <flux:separator variant="subtle"/>
    </div>

    <div class="space-y-4">
        <!--Search-->
        <div class="grid md:grid-cols-6 gap-2">
            <flux:input wire:model.live.debounce.500ms="search_name" type="text" clearable icon="magnifying-glass"
                kbd="⌘K" placeholder="{{ trans('Name') }}" clearable />
            <flux:input wire:model.live.debounce.500ms="search_with_address" id="search" type="text" name="search"
                kbd="⌘K" clearable icon="magnifying-glass" placeholder="{{ trans('Installation Address') }}"
                clearable />
            <flux:select wire:model.change="selectedServer">
                <flux:select.option value=""> {{ trans('customer.paket.ph.all-server') }}
                </flux:select.option>
                @foreach (\App\Models\Servers\Mikrotik::where('disabled', false)->orderBy('name', 'asc')->get() as $mikrotik)
                    <flux:select.option value="{{ $mikrotik->id }}">
                        {{ $mikrotik->name }}
                    </flux:select.option>
                @endforeach
            </flux:select>

            <flux:select wire:model.change="search_with_paket" wire:key="{{ $selectedServer }}">
                <flux:select.option value="">{{ trans('customer.paket.ph.all-paket') }}</flux:select.option>
                @if ($selectedServer)
                    @foreach (\App\Models\Servers\Mikrotik::whereId($selectedServer)->first()->paketsOrderByPrice->where('disabled', false) as $paket)
                        <flux:select.option value="{{ $paket->id }}">{{ $paket->name }}</flux:select.option>
                    @endforeach
                @endif
            </flux:select>

            <flux:select wire:model.change="search_with_internet_service">
                <flux:select.option value="">{{ trans('customer.paket.ph.all-internet-service') }}
                </flux:select.option>
                <flux:select.option value="1">{{ trans('customer.paket.ph.ppp') }}
                </flux:select.option>
                <flux:select.option value="2">{{ trans('customer.paket.ph.static') }}</flux:select.option>
            </flux:select>

            <flux:select wire:model.change="search_with_status_customer_paket">
                <flux:select.option value="">{{ trans('customer.paket.status.all-status') }}</flux:select.option>
                <flux:select.option value="active">{{ trans('customer.paket.status.active') }}</flux:select.option>
                <flux:select.option value="suspended">{{ trans('customer.paket.status.suspended') }}</flux:select.option>
                <flux:select.option value="cancelled">{{ trans('customer.paket.status.cancelled') }}</flux:select.option>
                <flux:select.option value="expired">{{ trans('customer.paket.status.expired') }}</flux:select.option>
                <flux:select.option value="pending">{{ trans('customer.paket.status.pending') }}</flux:select.option>
                <flux:select.option value="online">{{ trans('customer.paket.status.up') }}</flux:select.option>
                <flux:select.option value="offline">{{ trans('customer.paket.status.down') }}</flux:select.option>
            </flux:select>
        </div>

        <div class="grid md:grid-cols-6 gap-2">
            <flux:select wire:model.live="perPage">
                @foreach ($perPageOptions as $perPageOption)
                    <flux:select.option value="{{ $perPageOption }}">Per Page {{ $perPageOption }}</flux:select.option>
                @endforeach
            </flux:select>
            <div class="col-span-2">
                <x-input-date-range>
                    <x-slot name="start_date" wire:model="startDateDeadline"></x-slot>
                    <x-slot name="end_date" wire:model="endDateDeadline"></x-slot>
                </x-input-date-range>
            </div>
        </div>
    </div>

    <div wire:loading.class="opacity-75" class="mt-2">
        <flux:checkbox.group>
                <x-tables.table>
                    <x-slot name="header">
                        <x-tables.theader>
                            <x-tables.header>{{ trans('customer.table.no') }}</x-tables.header>
                            <x-tables.header sortable wire:click.prevent="sortBy('full_name')"
                                :direction="$sortField === 'full_name' ? $sortDirection : null">{{ trans('customer.table.name') }}</x-tables.header>

                            <x-tables.header>
                                <div class="grid md:grid-cols-3 gap-1">
                                    <div class="hidden md:inline">
                                        {{ trans('Installation Address') }}
                                    </div>
                                     <div>
                                         {{ trans('customer.table.paket') }}
                                    </div>
                                     <div class="hidden md:inline">
                                        {{ trans('Paket Action') }}
                                    </div>
                                </div>
                            </x-tables.header>
                            <x-tables.header>{{ trans('customer.table.action') }}</x-tables.header>
                        </x-tables.theader>
                    </x-slot>
                    <x-slot name="body">

                        @forelse ($customers as $key => $user)
                            <x-tables.row>
                                <x-tables.cell class="text-center">
                                    {{ ($customers->currentpage() - 1) * $customers->perpage() + $loop->index + 1 }}
                                </x-tables.cell>
                                <x-tables.cell>
                                    <div class="space-y-1">
                                        <flux:button size="xs" variant="primary" color="{{ $user->disabled ? 'red' : 'zinc' }}"
                                            style="cursor: pointer;" wire:navigate href="{{ route('customer.show', $user->username) }}">
                                            {{ $user->full_name }}
                                        </flux:button>

                                        <flux:text class="text-xs">
                                        {{ $user->address }}
                                        </flux:text>
                                    </div>
                                </x-tables.cell>

                                <x-tables.cell>
                                    <div class="flex flex-col gap-1">
                                        @forelse ($user->customer_pakets as $key => $customer_paket)

                                            <div class="grid md:grid-cols-3 gap-2 rounded-lg border-1 {{ $customer_paket->disabled || $customer_paket->status === 'pending' ? '' : ($customer_paket->status === 'active' ? 'border-green-500' : 'border-red-500') }} p-1">
                                                <div class="flex gap-1">
                                                    <flux:badge size="sm" class="cursor-pointer" wire:click="$dispatch('edit-customer-paket-address-modal',{customerPaket: '{{ $customer_paket->slug }}'})">
                                                        <x-slot name="icon">
                                                            <flux:icon.map-pin class="text-red-500" variant="micro"/>
                                                        </x-slot>
                                                    </flux:badge>
                                                    <flux:text size="xs">
                                                        {{ $customer_paket->full_customer_installation_address }}
                                                    </flux:text>
                                                </div>
                                                <div class="place-content-center">
                                                    <div class="flex flex-col gap-1">
                                                        @php
                                                            $expiredDate = \Carbon\Carbon::parse($customer_paket->expired_date);
                                                        @endphp
                                                        <flux:field variant="inline">
                                                            <flux:checkbox wire:model.live="customerPaketSelected"  wire:key="{{ $customer_paket->slug }}" value="{{ $customer_paket->id }}" />
                                                            <flux:label class="text-zinc-500 dark:text-white/70" :textAssideClass="$expiredDate->isPast() ? 'text-red-500' : ($expiredDate->subDays(3)->isPast() ? 'text-yellow-500' : 'text-green-800')" aside="E: {{ \Carbon\Carbon::parse($customer_paket->expired_date)->format('d-m-Y') }}">{{ $customer_paket->paket->name }}</flux:label>
                                                        </flux:field>
                                                    </div>
                                                </div>
                                                <div class="place-content-center">
                                                    <x-customer-paket.status-and-action :customerPaket="$customer_paket" :user="$user" size="xs" />
                                                </div>
                                            </div>

                                        @empty
                                            <flux:badge size="sm" color="zinc" class="justify-center">
                                                No Paket
                                            </flux:badge>
                                        @endforelse
                                    </div>

                                </x-tables.cell>
                                <x-tables.cell>
                                    <div class="flex gap-2 justify-end">
                                        <flux:button.group>
                                            @if (is_null($user->email_verified_at))
                                                <flux:button size="xs" title="Verification" style="cursor: pointer;"
                                                    wire:click="verificationUser('{{ $user->username }}')">
                                                    <flux:icon.check variant="micro" class="text-red-500" />
                                                </flux:button>
                                            @else
                                                @if (!$user->disabled)
                                                    <flux:button size="xs" variant="primary" icon="plus-circle"
                                                        style="cursor: pointer;"
                                                        wire:click="$dispatch('add-customer-paket-modal',{user: '{{ $user->username }}'})"
                                                        title="{{ trans('customer.button.add-paket') }}" />
                                                @endif

                                                @if ($user->invoices->where('status', '!=', 'paid')->count())
                                                    <flux:tooltip
                                                        content="{{ $user->invoices->where('status', '!=', 'paid')->count() }} invoices">
                                                        <flux:button size="xs" variant="primary" color="green" icon="currency-dollar"
                                                            style="cursor: pointer;" wire:navigate
                                                            href="{{ route('billings.customer.billing', $user->username) }}" />
                                                    </flux:tooltip>
                                                @endif

                                                <flux:button size="xs" variant="primary" icon="eye"
                                                    style="cursor: pointer;" wire:navigate
                                                    href="{{ route('customer.show', $user->username) }}"
                                                    title="{{ trans('customer.button.show-customer') }}" />
                                            @endif

                                        </flux:button.group>
                                    </div>
                                </x-tables.cell>
                            </x-tables.row>
                        @empty
                            <x-tables.row>
                                <x-tables.cell colspan=4>
                                    <div class="flex justify-center items-center">
                                        <span class="font-medium py-8 text-gray-400 text-xl">
                                            {{ trans('customer.customer-paket-notfound') }}
                                        </span>
                                    </div>
                                </x-tables.cell>
                            </x-tables.row>
                        @endforelse
                        @if ($customers->count())
                            <x-tables.row>
                                <x-tables.cell></x-tables.cell>
                                <x-tables.cell></x-tables.cell>

                                <x-tables.cell>
                                    <div class="flex gap-2">
                                        <flux:checkbox.all wire:key="{{ Illuminate\Pagination\LengthAwarePaginator::resolveCurrentPage() }}" label="Select All Paket"/>
                                        @if (collect($customerPaketSelected)->count())
                                            <flux:tooltip content="{{ trans('customer.helper.tooltip-bulk-delete-customer-paket') }}">
                                                <flux:button size="xs" variant="danger" icon="trash" style="cursor: pointer;" wire:click="bulkDeleteCustomerPaket" disabled>
                                                    {{ trans('customer.button.bulk-delete-customer-paket', ['count' => collect($customerPaketSelected)->count()]) }}
                                                </flux:button>
                                            </flux:tooltip>
                                            <flux:tooltip content="{{ trans('customer.helper.tooltip-bulk-edit-activation-customer-paket') }}">
                                                <flux:button size="xs" variant="primary" icon="pencil"
                                                    style="cursor: pointer;" wire:click="bulkEditCustomerPaket">
                                                    {{ trans('customer.button.bulk-edit-activation', ['count' => collect($customerPaketSelected)->count()]) }}
                                                </flux:button>
                                            </flux:tooltip>
                                        @endif
                                    </div>
                                </x-tables.cell>
                                <x-tables.cell>
                                </x-tables.cell>
                            </x-tables.row>
                        @endif
                    </x-slot>
                </x-tables.table>

        </flux:checkbox.group>

        @if ($customers->hasPages())
            <div class="p-3">
                {{ $customers->links() }}
            </div>
        @endif
    </div>

    <!--Customer Paket Modal-->
    <livewire:admin.customers.modal.customer-paket.add-customer-paket-modal />
    <livewire:admin.customers.modal.customer-paket.edit-customer-paket-address-modal />
    <livewire:admin.customers.modal.customer-paket.edit-mac-address />
    <livewire:admin.customers.modal.customer-paket.activation-paket />
    <livewire:admin.customers.modal.customer-paket.bulk-edit-activation />
    <livewire:admin.customers.modal.customer-paket.disable-customer-paket />
    <livewire:admin.customers.modal.customer-paket.disable-wa-notification-installation-address />
    <!--Send message-->
    <livewire:admin.whatsapp-gateway.modal.notification-message.send-message-all-customer-paket />
</div>
