<div>
    @if ($addPhoneNumberModal)
        <flux:modal wire:model="addPhoneNumberModal" class="md:w-120 w-[90%]" :dismissible="false" @close="closeModal()">
            <div class="space-y-6">
                <div>
                    <flux:heading size="lg">
                        {{ trans('Add Phone Number') }}
                    </flux:heading>
                </div>
                @if ($errors->any())
                    <flux:callout variant="danger" icon="exclamation-triangle">
                        <flux:callout.heading>Error</flux:callout.heading>
                        <flux:callout.text>
                            <ol class="list-decimal text-xs">
                                @foreach ($errors->all() as $error)
                                    <li>
                                        {{ $error }}
                                    </li>
                                @endforeach
                            </ol>
                        </flux:callout.text>
                    </flux:callout>
                @endif
                <form wire:submit="editPhoneNumber" class="space-y-4">
                    <!--phone -->
                    <flux:input wire:model="input.phone" id="phone" type="text" :invalid="$errors->first('phone')" autofocus autocomplete="phone" variant="floating" name="phone" :label="__('user.label.phone')"
                        placeholder="{{ __('customer.ph.phone') }}" />

                    @if ($user->customer_pakets->count())
                        <!--update installation address -->
                        <flux:checkbox wire:model="updateInstallationPhoneNumber"
                            label="{{ trans('Update installation phone number.') }}" />
                        <!--update billing address -->
                        <flux:checkbox wire:model="updateBillingPhoneNumber"
                            label="{{ trans('Update billing phone number.') }}" />
                    @endif

                    <div class="flex items-center justify-end gap-2">
                        <flux:button wire:click="closeModal()" variant="ghost" class="cursor-pointer">
                            {{ __('Cancel') }}
                        </flux:button>
                        <flux:button type="submit" variant="primary" class="cursor-pointer">
                            {{ __('Save') }}
                        </flux:button>
                    </div>
                </form>
            </div>
        </flux:modal>
    @endif
</div>
