<div>
    @if ($createInvoiceFileModal)
        <flux:modal class="md:w-120 w-[90%]" wire:model="createInvoiceFileModal" :dismissible="false" @close="closeModal()">
            <div class="space-y-4">
                <flux:label>{!! trans('Paket') !!}</flux:label>
                <flux:select wire:model.live="input.selectedPaket" name="selectedPaket">
                    <flux:select.option value="">{{ trans('Select Paket') }}</flux:select.option>
                    @foreach ($customerPakets as $customerPaket)
                        <flux:select.option :value="$customerPaket->id">{{ $customerPaket->paket->name }}
                        </flux:select.option>
                    @endforeach
                </flux:select>
                <div class="flex items-center justify-end gap-2">
                    <flux:button wire:click="closeModal()" variant="ghost" class="cursor-pointer">
                        {{ trans('billing.button.cancel') }}
                    </flux:button>

                     @if ($fileExist)
                        <flux:button wire:click="download_invoices" variant="primary" iconTrailing="arrow-right">
                            {{ __('billing.button.download-invoice') }}
                        </flux:button>
                    @else
                        <flux:button wire:click="exportInvoices" variant="primary" iconTrailing="arrow-right">
                            {{ __('billing.button.create-invoices', ['count'=> $invoices->count()]) }}
                        </flux:button>
                    @endif

                </div>
            </div>
        </flux:modal>
    @endif
</div>
