<div>
    @if ($createInvoiceModal)
        <flux:modal class="md:w-120 w-[90%]" wire:model="createInvoiceModal" :dismissible="false" @close="closeModal()">
            <form wire:submit="createInvoice" class="space-y-4">
                <flux:label>{!! trans('Paket') !!}</flux:label>
                <flux:select wire:model.live="input.selectedPaket" name="selectedPaket">
                    <flux:select.option value="">{{ trans('Select Paket') }}</flux:select.option>
                    @foreach ($customerPakets as $customerPaket)
                        <flux:select.option :value="$customerPaket->id">{{ $customerPaket->paket->name }}
                        </flux:select.option>
                    @endforeach
                </flux:select>
                <div class="flex items-center justify-end gap-2">
                    <flux:button wire:click="closeModal()" variant="ghost" class="cursor-pointer">
                        {{ trans('billing.button.cancel') }}
                    </flux:button>

                    <flux:button type="submit" variant="primary" color="green" iconTrailing="arrow-right" class="cursor-pointer">
                        {{ __('Create Invoice') }}
                    </flux:button>
                </div>
            </form>
        </flux:modal>
    @endif
</div>
