<div>
    @if ($disableCustomerPaketModal)
    <flux:modal class="md:w-120 w-[90%]" wire:model="disableCustomerPaketModal" :dismissible="false"
        @close="closeModal()">
        <div class="space-y-6">
            <div>
                    @if ($this->button === 'active')
                    <flux:heading size="lg">
                        {!! trans('customer.paket.alert.header-activate-paket', [
                        'paket' => $customerPaket->paket->name,
                        'customer' => $customerPaket->user->full_name,
                        ]) !!}
                    </flux:heading>
                    <flux:text class="mt-2">
                        {!! trans('customer.paket.alert.content-activate-paket', [
                        'paket' => $customerPaket->paket->name,
                        'customer' => $customerPaket->user->full_name,
                        ]) !!}
                    </flux:text>
                    @elseif ($this->button === 'expired')
                    <flux:heading size="lg">
                        {!! trans('customer.paket.alert.header-expired-paket', [
                        'paket' => $customerPaket->paket->name,
                        'customer' => $customerPaket->user->full_name,
                        ]) !!}
                    </flux:heading>
                    <flux:text class="mt-2">
                        {!! trans('customer.paket.alert.content-expired-paket', [
                        'paket' => $customerPaket->paket->name,
                        'customer' => $customerPaket->user->full_name,
                        ]) !!}
                    </flux:text>

                    @elseif ($this->button === 'suspended')
                    <flux:heading size="lg">
                        {!! trans('customer.paket.alert.header-suspended-paket', [
                        'paket' => $customerPaket->paket->name,
                        'customer' => $customerPaket->user->full_name,
                        ]) !!}
                    </flux:heading>
                    <flux:text class="mt-2">
                        {!! trans('customer.paket.alert.content-suspended-paket', [
                        'paket' => $customerPaket->paket->name,
                        'customer' => $customerPaket->user->full_name,
                        ]) !!}
                    </flux:text>

                    @elseif ($this->button === 'cancelled')
                    <flux:heading size="lg">
                        {!! trans('customer.paket.alert.header-cancelled-paket', [
                        'paket' => $customerPaket->paket->name,
                        'customer' => $customerPaket->user->full_name,
                        ]) !!}
                    </flux:heading>
                    <flux:text class="mt-2">
                        {!! trans('customer.paket.alert.content-cancelled-paket', [
                        'paket' => $customerPaket->paket->name,
                        'customer' => $customerPaket->user->full_name,
                        ]) !!}
                    </flux:text>
                    @endif

            </div>
            <form wire:submit='update_status_paket'>
                <div class="flex flex-col gap-6">
                    <flux:select wire:model.change="input.status"
                        :label="__('customer.paket.ph.status')" name="status">
                        @foreach ($customerPaketStatuses as $customerPaketStatus)
                            <flux:select.option value="{{ $customerPaketStatus['value'] }}">{{ trans($customerPaketStatus['title']) }}</flux:select.option>
                        @endforeach
                    </flux:select>

                    <flux:input wire:model="input.current_password" :label="__('user.label.confirm-password')"
                        type="password" name="current_password" placeholder="{{ __('Input your password') }}" />

                    <div class="flex gap-2">
                        <flux:spacer />
                        <flux:button style="cursor: pointer;" variant="ghost" size="sm"
                            wire:click="$set('disableCustomerPaketModal', false)">
                            {{ trans('customer.button.cancel') }}
                        </flux:button>

                        <flux:button type="submit"
                            variant="primary" color="{{ $button == 'active' ? 'green':'red' }}" icon="check"
                            style="cursor: pointer;" size="sm">
                            {{ trans('customer.paket.button.'.$button) }}
                        </flux:button>
                    </div>
                </div>
            </form>
        </div>
    </flux:modal>
    @endif
</div>
