<div>
    @if ($disableWaInstallationAddressModal)
        <flux:modal class="md:w-120 w-[90%]" wire:model="disableWaInstallationAddressModal" :dismissible="false"
            @close="$dispatch('close-add-customer-modal')">
            <div class="space-y-6">
                <div>
                    <flux:heading size="lg">
                        {{ trans('customer.paket.wa-notification', ['customer' => $customerPaket->user->full_name]) }}
                    </flux:heading>
                </div>
                <form wire:submit='disable_wa_notification_installation_address'>
                    <div class="space-y-6">
                        <div class="space-y-4">
                            <div class="space-y-2">
                                <flux:checkbox wire:model.live="input.checkbox_wa_installation_address_notification"
                                    label="{{ trans('customer.paket.enable-wa-installation-address-notification') }}"
                                    description="{{ $input['checkbox_wa_installation_address_notification'] ? trans('customer.paket.enable-wa-installation-address-detail') : trans('customer.paket.disable-wa-installation-address-detail') }}"/>

                                @if ($input['checkbox_wa_installation_address_notification'])
                                    <div class="ms-4">
                                        <!--phone -->
                                        <flux:input wire:model="input.installation_phone" :label="__('customer.label.phone')"
                                            type="text" name="installation_phone" placeholder="{{ __('customer.ph.phone') }}" />
                                    </div>
                                @endif
                            </div>

                            <div class="space-y-2">
                                <flux:checkbox wire:model.live="input.checkbox_wa_billing_address_notification"
                                    label="{{ trans('customer.paket.enable-wa-billing-address-notification') }}"
                                    description="{{ $input['checkbox_wa_billing_address_notification'] ? trans('customer.paket.enable-wa-billing-address-detail') : trans('customer.paket.disable-wa-billing-address-detail') }}"/>
                                @if ($input['checkbox_wa_billing_address_notification'])
                                    <div class="ms-4">
                                        <!--phone -->
                                        <flux:input wire:model="input.billing_phone" :label="__('customer.label.phone')"
                                            type="text" name="billing_phone" placeholder="{{ __('customer.ph.phone') }}" />
                                    </div>
                                @endif
                            </div>
                        </div>
                        <div class="space-y-2">
                            <flux:input wire:model="input.current_password" :label="__('user.label.confirm-password')"
                                type="password" name="current_password" placeholder="{{ __('Input your password') }}" />

                            <div class="flex gap-2">
                                <flux:spacer />
                                <flux:button class="cursor-pointer" variant="ghost" size="sm" wire:click="$set('disableWaInstallationAddressModal', false)">
                                    {{ trans('customer.button.cancel') }}
                                </flux:button>

                                <flux:button type="submit" variant="primary" icon="check" class="cursor-pointer" size="sm">
                                    {{ trans('customer.button.update') }}
                                </flux:button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </flux:modal>
    @endif
</div>

