<div>
    @if ($disableWaNotificationModal)
        <flux:modal class="md:w-120 w-[90%]" wire:model="disableWaNotificationModal" :dismissible="false"
            @close="$dispatch('close-modal')">
            <div class="space-y-6">
                <div>
                    @if ($userAddress->wa_notification)
                        <flux:heading size="lg">
                            {{ trans('customer.paket.disable-wa-notification', ['customer' => $userAddress->user->full_name]) }}
                        </flux:heading>
                        <flux:text class="mt-2">
                            {{ trans('customer.paket.disable-wa-notification-detail') }}
                        </flux:text>
                    @else
                        <flux:heading size="lg">
                            {{ trans('customer.paket.enable-wa-notification', ['customer' => $userAddress->user->full_name]) }}
                        </flux:heading>
                        <flux:text class="mt-2">
                            {{ trans('customer.paket.enable-wa-notification-detail') }}
                        </flux:text>
                    @endif
                </div>
                <form wire:submit="disableWaNotification">

                    <div class="flex flex-col gap-6">
                        <flux:input wire:model="input.current_password" :label="__('user.label.confirm-password')"
                            type="password" name="current_password" placeholder="{{ __('Input your password') }}" />

                        <div class="flex gap-2">
                            <flux:spacer />
                            <flux:button style="cursor: pointer;" variant="ghost" size="sm" wire:click="$set('disableWaNotificationModal', false)">
                                {{ trans('customer.button.cancel') }}
                            </flux:button>


                                @if ($userAddress->wa_notification)
                                    <flux:button type="submit" variant="danger" icon="power" style="cursor: pointer;" size="sm">
                                        {{ trans('customer.button.disable-wa-notification') }}
                                    </flux:button>
                                @else
                                    <flux:button type="submit" variant="primary" color="green" icon="power" style="cursor: pointer;" size="sm">
                                        {{ trans('customer.button.enable-wa-notification') }}
                                    </flux:button>

                                @endif


                        </div>
                    </div>
                </form>
            </div>
        </flux:modal>
    @endif
</div>
