<section class="w-full">
    <x-layouts.help>
        <flux:callout icon="user-group" color="zinc">
            <flux:callout.heading>Menambahkan Pelanggan</flux:callout.heading>

            <flux:callout.text>
                Untuk mulai menambahkan pelanggan, anda dapat mengunjungi halaman
                <flux:callout.link :external="true" :href="route('customers.management')">Customer</flux:callout.link>
            </flux:callout.text>

            <flux:callout.text>
                Kemudian tekan tombol <flux:button size="sm" variant="primary" icon="plus-circle" class="cursor-pointer"
                    title="{{ trans('customer.button.create') }}">
                    {{ __('customer.button.create') }}
                </flux:button>
            </flux:callout.text>

            <div class="mt-4">
                <flux:callout.text>
                Kemudian isi data customer
                </flux:callout.text>
                <div class="space-y-6">
                    <div class="space-y-6 md:w-120 w-[90%] bg-white p-4 border rounded-lg">
                        <div>
                            <flux:heading size="lg">
                                {{ trans('customer.add-customer') }}
                            </flux:heading>
                            <flux:subheading>
                                {{ trans('customer.add-customer') }}
                            </flux:subheading>
                        </div>
                        <div class="space-y-6">
                            <div class="grid md:grid-cols-2 gap-4">
                                <flux:input type="text" variant="floating" :label="__('user.label.first-name')" placeholder="{{ __('user.ph.first-name') }}" />
                                <flux:input type="text" variant="floating" name="last_name" :label="__('user.label.last-name')" placeholder="{{ __('user.ph.last-name') }}" />
                            </div>

                            <div class="grid md:grid-cols-2 gap-4">
                                <!--Gender-->
                                <flux:select name="gender" variant="floating" :label="__('customer.label.gender')">
                                    <flux:select.option value="">{{ trans('customer.ph.select-gender') }}
                                    </flux:select.option>
                                    <flux:select.option value="male">{{ trans('customer.ph.male') }}
                                    </flux:select.option>
                                    <flux:select.option value="female">{{ trans('customer.ph.female') }}
                                    </flux:select.option>
                                </flux:select>

                                <!--DOB-->
                                <flux:input type="date" max="2010-12-31" variant="floating" name="dob" :label="__('customer.label.dob')"/>
                            </div>

                            <div class="flex items-center justify-end">
                                <flux:button variant="primary" iconTrailing="arrow-right">
                                    {{ __('Next') }}
                                </flux:button>
                            </div>
                        </div>
                    </div>

                    <div class="space-y-6 md:w-120 w-[90%] bg-white p-4 border rounded-lg">
                        <!--Country-->
                        <flux:input icon="magnifying-glass" :placeholder="trans('address.select-country')"/>

                        <div class="grid md:grid-cols-2 gap-4">
                            <flux:input icon="magnifying-glass" :placeholder="trans('address.select-province')"/>
                            <flux:input icon="magnifying-glass" :placeholder="trans('address.select-city')"/>
                        </div>
                        <div class="grid md:grid-cols-2 gap-4">
                            <flux:input icon="magnifying-glass" :placeholder="trans('address.select-district')"/>
                            <flux:input icon="magnifying-glass" :placeholder="trans('address.select-sub-district')"/>

                        </div>
                        <div class="grid md:grid-cols-2 gap-4">
                            <!--Address -->
                            <flux:input type="text" variant="floating" name="address" :label="__('user.label.address')" placeholder="{{ __('customer.ph.address') }}" />
                            <!--phone -->
                            <flux:input type="text" :invalid="$errors->first('phone')" variant="floating" :label="__('user.label.phone')" placeholder="{{ __('customer.ph.phone') }}" />
                        </div>
                        <div class="flex items-center justify-end gap-2">
                            <flux:button variant="primary" icon="arrow-left">
                                {{ __('Back') }}
                            </flux:button>
                            <flux:button variant="primary" iconTrailing="arrow-right">
                                {{ __('Next') }}
                            </flux:button>
                        </div>
                    </div>

                    <div class="space-y-6 md:w-120 w-[90%] bg-white p-4 border rounded-lg">
                        <div class="grid md:grid-cols-2 gap-4">
                            <!--Address -->
                            <flux:input type="text" variant="floating" name="address" label="Email address" placeholder="email@example.com" />
                            <!--phone -->
                            <flux:input type="text" :invalid="$errors->first('phone')" variant="floating" label="Password" placeholder="Password" />
                        </div>
                        <div class="flex items-center justify-end gap-2">
                            <flux:button variant="primary" icon="arrow-left">
                                {{ __('Back') }}
                            </flux:button>
                            <flux:button variant="primary" iconTrailing="arrow-right">
                                {{ __('Add Customer') }}
                            </flux:button>
                        </div>
                    </div>
                </div>
            </div>
        </flux:callout>




    </x-layouts.help>
</section>
