<section class="w-full">
    <x-layouts.help>
        <div class="space-y-6">
            <flux:callout icon="wallet" color="zinc">
                <flux:callout.heading>
                    Payment Gateway Tripay
                </flux:callout.heading>
                <flux:callout.text>
                    Sebelum anda melakukan konfigurasi tripay, pastikan anda sudah memiliki akun tripay.
                </flux:callout.text>
                <flux:callout.text>
                    Jika anda belum memiliki akun tripay, anda bisa melakukan pendaftaran melalui
                    <flux:button variant="primary" color="sky" size="sm" target="_blank" href="https://tripay.co.id/?ref=TP38753">
                        Daftar Tripay
                    </flux:button>
                </flux:callout.text>

                <flux:callout.text>
                    Jika anda sudah memiliki akun tripay, lakukan konfigurasi sebagai berikut:
                </flux:callout.text>

                <flux:callout.text>
                Biasanya Tripay akan meminta URL Callback untuk mengirimkan status pembayaran.
                </flux:callout.text>
                <flux:callout.text>
                Masukkan URL Callback: https://namadomain/tripay/response
                </flux:callout.text>

                <flux:callout.text>
                <flux:input value="{{ env('APP_URL').'/tripay/response'}}" copyable />
                </flux:callout.text>

                <flux:callout.text>
                <ul class="list-disc">
                        <li>Ganti <flux:badge size="sm" color="lime">nama-domain</flux:badge>
                            dengan domain atau ip publik yang mengarah ke server customer management.</li>
                        <li>Pastikan server customer management anda dapat diakses secara publik.</li>
                        <li>Untuk memulai uji coba silahkan ikuti panduan pada website tripay.</li>
                    </ul>
                </flux:callout.text>

            </flux:callout>
            <flux:callout icon="cog" color="zinc">
                <flux:callout.heading>
                    Konfigurasi Tripay di Customer Management
                </flux:callout.heading>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div class="space-y-2 mt-4">
                        <flux:callout.heading>
                            Production
                        </flux:callout.heading>
                        <flux:callout.text>
                            Merchant ID: Diisi dengan Kode Merchant Tripay
                        </flux:callout.text>
                        <flux:callout.text>
                            API Key: Diisi dengan API Key Production Tripay
                        </flux:callout.text>
                        <flux:callout.text>
                        Secret Key: Diisi dengan Private Key Production Tripay
                        </flux:callout.text>

                        <div class="md:w-96 relative overflow-hidden rounded-xl border border-neutral-200 dark:border-neutral-700 p-6 mt-6">
                            <div class="flex flex-col gap-2">
                                <div class="flex justify-between gap-2">
                                    <div class="flex justify-start gap-2">
                                        <flux:heading size="xl" class="font-bold">TriPay</flux:heading>
                                    </div>
                                    <div class="flex justify-between gap-2">
                                        <flux:field variant="inline">
                                            <flux:checkbox checked />
                                            <flux:label>
                                                <flux:badge color="lime">{{ trans('Enable') }}
                                                </flux:badge>
                                            </flux:label>
                                        </flux:field>
                                    </div>
                                </div>
                                <flux:separator class="my-2" />
                                <div class="flex flex-col gap-2 opacity-100">
                                    <flux:badge class="mt-4 font-semibold" color="sky" size="lg">
                                        <flux:field variant="inline">
                                            <flux:checkbox checked />
                                            <flux:label>Production</flux:label>
                                        </flux:field>
                                    </flux:badge>

                                    <flux:field>
                                        <flux:input.group>
                                            <flux:input.group.prefix class="w-1/2">{{ __('Merchant Code') }}
                                            </flux:input.group.prefix>
                                            <flux:input type="text" value="Txxxx"
                                                placeholder="{{ __('Merchant Code') }}" />
                                        </flux:input.group>
                                        <flux:error name="merchant_code" />
                                    </flux:field>

                                    <flux:field>
                                        <flux:input.group>
                                            <flux:input.group.prefix class="w-1/2">{{ __('API Key') }}
                                            </flux:input.group.prefix>
                                            <flux:input type="text" value="XXXXXXXXXXXXXX"
                                                placeholder="{{ __('API Key') }}" />
                                        </flux:input.group>
                                        <flux:error name="production_api_key" />
                                    </flux:field>

                                    <flux:field>
                                        <flux:input.group>
                                            <flux:input.group.prefix class="w-1/2">{{ __('Secret Key') }}
                                            </flux:input.group.prefix>
                                            <flux:input type="text" value="XXXXXXXXXXXXXX"
                                                placeholder="{{ __('Secret Key') }}" />
                                        </flux:input.group>
                                        <flux:error name="production_secret_key" />
                                    </flux:field>

                                    <flux:badge class="mt-4 font-semibold" color="yellow" size="lg">
                                        <flux:field variant="inline">
                                            <flux:checkbox disabled />
                                            <flux:label>Development</flux:label>
                                        </flux:field>
                                    </flux:badge>

                                    <flux:field>
                                        <flux:input.group>
                                            <flux:input.group.prefix class="w-1/2">{{ __('Merchant Code') }}
                                            </flux:input.group.prefix>
                                            <flux:input type="text" value="Txxxx"
                                                placeholder="{{ __('Merchant Code') }}" />
                                        </flux:input.group>
                                        <flux:error name="merchant_code" />
                                    </flux:field>

                                    <flux:field>
                                        <flux:input.group>
                                            <flux:input.group.prefix class="w-1/2">{{ __('API Key') }}
                                            </flux:input.group.prefix>
                                            <flux:input type="text" value="XXXXXXXXXXXXXX"
                                                placeholder="{{ __('API Key') }}" />
                                        </flux:input.group>
                                    </flux:field>

                                    <flux:field>
                                        <flux:input.group>
                                            <flux:input.group.prefix class="w-1/2">{{ __('Secret Key') }}
                                            </flux:input.group.prefix>
                                            <flux:input type="text" value="XXXXXXXXXXXXXX"
                                                placeholder="{{ __('Secret Key') }}" />

                                        </flux:input.group>
                                        <flux:error name="development_secret_key" />
                                    </flux:field>

                                    <div class="flex items-center justify-end gap-2">
                                        <flux:button type="submit" variant="primary" iconTrailing="arrow-right">
                                            {{ __('customer.button.save') }}
                                        </flux:button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="space-y-2 mt-4">
                        <flux:callout.heading>
                            Development
                        </flux:callout.heading>
                        <flux:callout.text>
                            Merchant ID: Diisi dengan Kode Merchant Sandbox Tripay
                        </flux:callout.text>
                        <flux:callout.text>
                            API Key: Diisi dengan API Key Sandbox Tripay
                        </flux:callout.text>
                        <flux:callout.text>
                            Secret Key: Diisi dengan Private Key Sandbox Tripay
                        </flux:callout.text>

                        <div class="md:w-96 relative overflow-hidden rounded-xl border border-neutral-200 dark:border-neutral-700 p-6 mt-6">
                            <div class="flex flex-col gap-2">
                                <div class="flex justify-between gap-2">
                                    <div class="flex justify-start gap-2">
                                        <flux:heading size="xl" class="font-bold">TriPay</flux:heading>
                                    </div>
                                    <div class="flex justify-between gap-2">
                                        <flux:field variant="inline">
                                            <flux:checkbox checked />
                                            <flux:label>
                                                <flux:badge color="lime">{{ trans('Enable') }}
                                                </flux:badge>
                                            </flux:label>
                                        </flux:field>
                                    </div>
                                </div>
                                <flux:separator class="my-2" />
                                <div class="flex flex-col gap-2 opacity-100">
                                    <flux:badge class="mt-4 font-semibold" color="sky" size="lg">
                                        <flux:field variant="inline">
                                            <flux:checkbox disabled/>
                                            <flux:label>Production</flux:label>
                                        </flux:field>
                                    </flux:badge>

                                    <flux:field>
                                        <flux:input.group>
                                            <flux:input.group.prefix class="w-1/2">{{ __('Merchant Code') }}
                                            </flux:input.group.prefix>
                                            <flux:input type="text" value="Txxxx"
                                                placeholder="{{ __('Merchant Code') }}" />
                                        </flux:input.group>
                                        <flux:error name="merchant_code" />
                                    </flux:field>

                                    <flux:field>
                                        <flux:input.group>
                                            <flux:input.group.prefix class="w-1/2">{{ __('API Key') }}
                                            </flux:input.group.prefix>
                                            <flux:input type="text" value="XXXXXXXXXXXXXX"
                                                placeholder="{{ __('API Key') }}" />
                                        </flux:input.group>
                                        <flux:error name="production_api_key" />
                                    </flux:field>

                                    <flux:field>
                                        <flux:input.group>
                                            <flux:input.group.prefix class="w-1/2">{{ __('Secret Key') }}
                                            </flux:input.group.prefix>
                                            <flux:input type="text" value="XXXXXXXXXXXXXX"
                                                placeholder="{{ __('Secret Key') }}" />
                                        </flux:input.group>
                                        <flux:error name="production_secret_key" />
                                    </flux:field>

                                    <flux:badge class="mt-4 font-semibold" color="yellow" size="lg">
                                        <flux:field variant="inline">
                                            <flux:checkbox checked />
                                            <flux:label>Development</flux:label>
                                        </flux:field>
                                    </flux:badge>

                                    <flux:field>
                                        <flux:input.group>
                                            <flux:input.group.prefix class="w-1/2">{{ __('Merchant Code') }}
                                            </flux:input.group.prefix>
                                            <flux:input type="text" value="Txxxx"
                                                placeholder="{{ __('Merchant Code') }}" />
                                        </flux:input.group>
                                        <flux:error name="merchant_code" />
                                    </flux:field>

                                    <flux:field>
                                        <flux:input.group>
                                            <flux:input.group.prefix class="w-1/2">{{ __('API Key') }}
                                            </flux:input.group.prefix>
                                            <flux:input type="text" value="XXXXXXXXXXXXXX"
                                                placeholder="{{ __('API Key') }}" />
                                        </flux:input.group>
                                    </flux:field>

                                    <flux:field>
                                        <flux:input.group>
                                            <flux:input.group.prefix class="w-1/2">{{ __('Secret Key') }}
                                            </flux:input.group.prefix>
                                            <flux:input type="text" value="XXXXXXXXXXXXXX"
                                                placeholder="{{ __('Secret Key') }}" />

                                        </flux:input.group>
                                        <flux:error name="development_secret_key" />
                                    </flux:field>

                                    <div class="flex items-center justify-end gap-2">
                                        <flux:button type="submit" variant="primary" iconTrailing="arrow-right">
                                            {{ __('customer.button.save') }}
                                        </flux:button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </flux:callout>
        </div>
    </x-layouts.help>
</section>
