<div class="w-full p-3">
    <div class="bg-white dark:bg-white/10 shadow-xs border border-zinc-200 border-b-zinc-300/80 dark:border-white/10 rounded text-zinc-800 dark:text-white">
        <div class="border-b border-zinc-200 border-b-zinc-300/80 dark:border-white/10 p-3 text-sm">
            <div class="flex justify-between">
                <div class="justify-start">
                    {!! trans('roles.titles.roles-card') !!}
                </div>
                <div class="justify-between">
                    <flux:badge size="sm" variant="pill" icon-trailing="shield-exclamation" color="green">
                        {!! trans_choice('roles.cards.roles-count', count($items), [
                        'count' => count($items),
                        ]) !!}
                    </flux:badge>
                </div>
            </div>
        </div>
        <div class="p-3 w-full bg-white dark:bg-white/10  text-zinc-800 dark:text-white space-y-1 text-sm">
            <div class="w-full divide-y divide-outline overflow-hidden rounded-radius border border-outline bg-surface-alt/40 text-on-surface dark:divide-outline-dark dark:border-outline-dark dark:bg-surface-dark-alt/50 dark:text-on-surface-dark">
                @forelse ($items as $itemKey => $item)
                    <div x-data="{ isExpanded: false }">
                        <div class="grid grid-cols-2 md:grid-cols-3 w-full items-center justify-between gap-4 p-4">
                            <div>
                                <strong class="text-blue-500 dark:text-gray-300">{{ Str::apa($item['role']->name) }}</strong>
                            </div>
                            <div class="hidden md:inline">
                                <flux:badge class="me-2" icon-trailing="user-circle" size="sm" variant="pill">
                                    {!! trans_choice('roles.cards.users-count', count($item['users']), ['count' =>
                                    count($item['users'])]) !!}
                                </flux:badge>

                                <flux:badge size="sm" variant="pill" icon-trailing="shield-exclamation">
                                    {!! trans_choice('roles.cards.permissions-count', count($item['permissions']), [
                                    'count' => count($item['permissions']),
                                    ]) !!}
                                </flux:badge>
                            </div>
                            <div class="flex justify-end space-x-2">
                                <div class="place-content-center">
                                    <a wire:click="$dispatch('show-edit-role-modal',{role: '{{ $item['role']->id }}'})" class="block text-xs font-semibold text-slate-800 cursor-pointer">
                                       Edit
                                    </a>

                                </div>
                                    <button id="controlsAccordionItemOne" type="button" class="bg-surface-alt text-left underline-offset-2 hover:bg-surface-alt/75 focus-visible:bg-surface-alt/75 focus-visible:underline focus-visible:outline-hidden dark:bg-surface-dark-alt dark:hover:bg-surface-dark-alt/75 dark:focus-visible:bg-surface-dark-alt/75" aria-controls="accordionItemOne" x-on:click="isExpanded = ! isExpanded" x-bind:class="isExpanded ? 'text-on-surface-strong dark:text-on-surface-dark-strong font-bold'  : 'text-on-surface dark:text-on-surface-dark font-medium'" x-bind:aria-expanded="isExpanded ? 'true' : 'false'">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke-width="2" stroke="currentColor" class="size-5 shrink-0 transition" aria-hidden="true" x-bind:class="isExpanded  ?  'rotate-180'  :  ''">
                                    <path stroke-linecap="round" stroke-linejoin="round" d="M19.5 8.25l-7.5 7.5-7.5-7.5"/>
                                </svg>
                            </button>
                            </div>
                        </div>

                        <div x-cloak x-show="isExpanded" id="accordionItemOne" role="region" aria-labelledby="controlsAccordionItemOne" x-collapse>
                            <div class="p-4 text-sm sm:text-base text-pretty">


                                <div class="w-full divide-y divide-outline overflow-hidden rounded-radius border border-outline bg-surface-alt/40 text-on-surface dark:divide-outline-dark dark:border-outline-dark dark:bg-surface-dark-alt/50 dark:text-on-surface-dark">
                                    <div x-data="{ isExpanded: false }">
                                        <button id="controlsAccordionItemOne" type="button" class="text-xs flex w-full items-center justify-between gap-4 bg-surface-alt p-4 text-left underline-offset-2 hover:bg-surface-alt/75 focus-visible:bg-surface-alt/75 focus-visible:underline focus-visible:outline-hidden dark:bg-surface-dark-alt dark:hover:bg-surface-dark-alt/75 dark:focus-visible:bg-surface-dark-alt/75" aria-controls="accordionItemOne" x-on:click="isExpanded = ! isExpanded" x-bind:class="isExpanded ? 'text-on-surface-strong dark:text-on-surface-dark-strong font-bold'  : 'text-on-surface dark:text-on-surface-dark font-medium'" x-bind:aria-expanded="isExpanded ? 'true' : 'false'">
                                            {!! trans('roles.cards.role-card.table-users-caption', ['role' => $item['role']->name]) !!}
                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke-width="2" stroke="currentColor" class="size-5 shrink-0 transition" aria-hidden="true" x-bind:class="isExpanded  ?  'rotate-180'  :  ''">
                                                <path stroke-linecap="round" stroke-linejoin="round" d="M19.5 8.25l-7.5 7.5-7.5-7.5"/>
                                            </svg>
                                        </button>
                                        <div x-cloak x-show="isExpanded" id="accordionItemOne" role="region" aria-labelledby="controlsAccordionItemOne" x-collapse>
                                            <div class="p-4 text-sm sm:text-base text-pretty">
                                                <!-- TABLE -->
                                                <div class="relative flex flex-col w-full h-full text-gray-700 bg-white shadow-md rounded-lg bg-clip-border">
                                                    <table class="w-full text-left table-auto min-w-max">
                                                        <thead>
                                                            <tr>
                                                                <th class="p-4 border-b border-slate-300 bg-slate-50">
                                                                <p class="block text-sm font-normal leading-none text-slate-500">
                                                                    {!! trans('roles.cards.role-card.user-id') !!}
                                                                </p>
                                                                </th>
                                                                <th class="p-4 border-b border-slate-300 bg-slate-50">
                                                                <p class="block text-sm font-normal leading-none text-slate-500">
                                                                   {!! trans('roles.cards.role-card.user-fullname') !!}
                                                                </p>
                                                                </th>
                                                                <th class="p-4 border-b border-slate-300 bg-slate-50">
                                                                <p class="block text-sm font-normal leading-none text-slate-500">
                                                                   {!! trans('roles.cards.role-card.user-email') !!}
                                                                </p>
                                                                </th>

                                                                <th class="p-4 border-b border-slate-300 bg-slate-50">
                                                                <p class="block text-sm font-normal leading-none text-slate-500"></p>
                                                                </th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            @forelse ($item['users'] as $itemUserKey => $itemUser)
                                                                <tr class="hover:bg-slate-50">
                                                                    <td class="p-4 border-b border-slate-200">
                                                                    <p class="block text-sm text-slate-800">
                                                                        {{ $itemUser->id }}
                                                                    </p>
                                                                    </td>
                                                                    <td class="p-4 border-b border-slate-200">
                                                                    <p class="block text-sm text-slate-800">
                                                                        {{ $itemUser->full_name }}
                                                                    </p>
                                                                    </td>
                                                                    <td class="p-4 border-b border-slate-200">
                                                                    <p class="block text-sm text-slate-800">
                                                                        {{ $itemUser->email }}
                                                                    </p>
                                                                    </td>

                                                                    <td class="p-4 border-b border-slate-200">
                                                                        <a href="#" class="block text-xs font-semibold text-slate-800">
                                                                            Delete
                                                                        </a>
                                                                    </td>
                                                                </tr>
                                                            @empty
                                                                <tr class="hover:bg-slate-50">
                                                                    <td colspan=4 class="p-4 border-b border-slate-200">
                                                                        <p class="block text-sm text-slate-800">
                                                                            <div class="flex justify-center items-center">
                                                                                <span class="font-medium py-8 text-zinc-800 dark:text-white text-xl">
                                                                                    User not found
                                                                                </span>
                                                                            </div>
                                                                        </p>
                                                                    </td>
                                                                </tr>
                                                            @endforelse
                                                        </tbody>
                                                    </table>
                                                </div>
                                                <!--END Table-->
                                            </div>
                                        </div>
                                    </div>
                                    <div x-data="{ isExpanded: false }">
                                        <button id="controlsAccordionItemOne" type="button" class="text-xs flex w-full items-center justify-between gap-4 bg-surface-alt p-4 text-left underline-offset-2 hover:bg-surface-alt/75 focus-visible:bg-surface-alt/75 focus-visible:underline focus-visible:outline-hidden dark:bg-surface-dark-alt dark:hover:bg-surface-dark-alt/75 dark:focus-visible:bg-surface-dark-alt/75" aria-controls="accordionItemOne" x-on:click="isExpanded = ! isExpanded" x-bind:class="isExpanded ? 'text-on-surface-strong dark:text-on-surface-dark-strong font-bold'  : 'text-on-surface dark:text-on-surface-dark font-medium'" x-bind:aria-expanded="isExpanded ? 'true' : 'false'">
                                            {!! trans('roles.cards.role-card.table-permissions-caption', ['role' => $item['role']->name,]) !!}
                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke-width="2" stroke="currentColor" class="size-5 shrink-0 transition" aria-hidden="true" x-bind:class="isExpanded  ?  'rotate-180'  :  ''">
                                                <path stroke-linecap="round" stroke-linejoin="round" d="M19.5 8.25l-7.5 7.5-7.5-7.5"/>
                                            </svg>
                                        </button>
                                        <div x-cloak x-show="isExpanded" id="accordionItemOne" role="region" aria-labelledby="controlsAccordionItemOne" x-collapse>
                                            <div class="p-4 text-sm sm:text-base text-pretty">
                                                <!-- TABLE -->
                                                <div class="relative flex flex-col w-full h-full text-gray-700 bg-white shadow-md rounded-lg bg-clip-border">
                                                    <table class="w-full text-left table-auto min-w-max">
                                                        <thead>
                                                            <tr>
                                                                <th class="p-4 border-b border-slate-300 bg-slate-50">
                                                                <p class="block text-sm font-normal leading-none text-slate-500">
                                                                    {!!  trans('roles.cards.role-card.permissions-id') !!}
                                                                </p>
                                                                </th>
                                                                <th class="p-4 border-b border-slate-300 bg-slate-50">
                                                                <p class="block text-sm font-normal leading-none text-slate-500">
                                                                    {!!  trans('roles.cards.role-card.permissions-name') !!}
                                                                </p>
                                                                </th>
                                                                <th class="p-4 border-b border-slate-300 bg-slate-50">
                                                                <p class="block text-sm font-normal leading-none text-slate-500"></p>
                                                                </th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            @forelse ($item['permissions'] as $itemPermissionKey => $itemPermission)
                                                                <tr class="hover:bg-slate-50">
                                                                    <td class="p-4 border-b border-slate-200">
                                                                    <p class="block text-sm text-slate-800">
                                                                        {{ $itemPermission->id }}
                                                                    </p>
                                                                    </td>
                                                                    <td class="p-4 border-b border-slate-200">
                                                                    <p class="block text-sm text-slate-800">
                                                                        {{ $itemPermission->name }}
                                                                    </p>
                                                                    </td>

                                                                    <td class="p-4 border-b border-slate-200">
                                                                    <a href="#" class="block text-sm font-semibold text-slate-800">
                                                                        Delete
                                                                    </a>
                                                                    </td>
                                                                </tr>
                                                            @empty
                                                                <tr class="hover:bg-slate-50">
                                                                    <td colspan=4 class="p-4 border-b border-slate-200">
                                                                        <p class="block text-sm text-slate-800">
                                                                            <div class="flex justify-center items-center">
                                                                                <span class="font-medium py-8 text-zinc-800 dark:text-white text-xl">
                                                                                    Permission not found
                                                                                </span>
                                                                            </div>
                                                                        </p>
                                                                    </td>
                                                                </tr>
                                                            @endforelse

                                                        </tbody>
                                                    </table>
                                                </div>
                                                <!--END Table-->
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                 @empty
                    <div class="text-center p-4">
                        <flux:text class="text-sm">
                            Roles not found
                        </flux:text>
                    </div>
                @endforelse
            </div>
        </div>
    </div>
</div>
<livewire:admin.roles.modal.edit-role />
