<div class="mb-5">

    <x-tables.table class="table-auto text-xs">
        <x-slot name="header">
            <x-tables.theader>
                <x-tables.header>{!! trans('roles.permissions-table.id') !!}</x-tables.header>
                <x-tables.header>{!! trans('roles.permissions-table.name') !!}</x-tables.header>
                <x-tables.header> {!! trans('roles.permissions-table.roles') !!}</x-tables.header>
                <x-tables.header>{!! trans('roles.permissions-table.actions') !!}</x-tables.header>
            </x-tables.theader>
        </x-slot>
        <x-slot name="body">
            @forelse ($items as $item)
            <x-tables.row>
                <x-tables.cell>{{ $item['permission']->id }}</x-tables.cell>
                <x-tables.cell>{{ Str::apa($item['permission']->name) }}</x-tables.cell>
                <x-tables.cell>
                    @forelse ($item['roles'] as $itemUserKey => $subItem)
                        <flux:text class="text-xs">
                            {{ Str::apa($subItem->name) }}
                        </flux:text>
                    @empty
                        <flux:text class="text-xs">
                            {!! trans('roles.cards.none-count') !!}
                        </flux:text>
                    @endforelse
                </x-tables.cell>
                <x-tables.cell class="text-center">
                    <flux:button icon="pencil" size="xs" variant="primary" style="cursor:pointer"
                        wire:click="$dispatch('show-edit-permission-modal',{permission: '{{ $item['permission']->id }}'})"
                        style="cursor:pointer" />
                </x-tables.cell>
            </x-tables.row>
            @empty
            <x-tables.row>
                <x-tables.cell colspan=7>
                    <div class="flex justify-center items-center">
                        <span class="font-medium py-8 dark:text-white text-xl">
                            {{ trans('roles.permission-notfound') }}
                        </span>
                    </div>
                </x-tables.cell>
            </x-tables.row>
            @endforelse
        </x-slot>
    </x-tables.table>
</div>
