<div class="mb-5">

    <x-tables.table class="table-auto text-xs">
        <x-slot name="header">
            <x-tables.theader>
                <x-tables.header>{!! trans('roles.roles-table.id') !!}</x-tables.header>
                <x-tables.header> {!! trans('roles.roles-table.name') !!}</x-tables.header>
                <x-tables.header>{!! trans('roles.roles-table.permissons') !!}</x-tables.header>
                <x-tables.header>{!! trans('roles.roles-table.actions') !!}</x-tables.header>
            </x-tables.theader>
        </x-slot>
        <x-slot name="body">
            @forelse ($items as $item)
            <x-tables.row>
                <x-tables.cell>{{ $item['role']->id }}</x-tables.cell>
                <x-tables.cell>{{ Str::apa($item['role']->name) }}</x-tables.cell>
                <x-tables.cell>

                    @forelse ($item['permissions'] as $itemPermKey => $itemPerm)
                        <flux:text class="text-xs">
                            {{ Str::apa($itemPerm->name) }}
                        </flux:text>
                    @empty
                        <flux:text class="text-xs">
                            {!! trans('roles.cards.none-count') !!}
                        </flux:text>
                    @endforelse
                </x-tables.cell>

                <x-tables.cell class="text-center">
                    <flux:button icon="pencil" size="xs" variant="primary" style="cursor:pointer"
                        wire:click="$dispatch('show-edit-role-modal',{role: '{{ $item['role']->id }}'})"
                        style="cursor:pointer" />
                </x-tables.cell>
            </x-tables.row>
            @empty
            <x-tables.row>
                <x-tables.cell colspan=4>
                    <div class="flex justify-center items-center">
                        <span class="font-medium py-8 text-zinc-800 dark:text-white text-xl">
                            {{ trans('roles.role-notfound') }}
                        </span>
                    </div>
                </x-tables.cell>
            </x-tables.row>
            @endforelse
        </x-slot>

    </x-tables.table>
</div>
