<section class="w-full">

    <x-layouts.general-setting :heading="__('Address')" :subheading="__('Manage address to our customer.')">
        <div class="space-y-6">
            @foreach ($addresses->whereNull('address_id') as $country)
                <div>
                    <flux:badge>{{ $country->name }}</flux:badge>
                    <div class="border rounded-lg mt-2 text-sm text-zinc-800 dark:text-white overflow-x-auto">
                        <div class="grid grid-cols-4 border-b text-center font-medium bg-gray-300 dark:bg-white/10 py-2">
                            <div class=" ">Province</div>
                            <div class="border-l">City</div>
                            <div class="border-l">District</div>
                            <div class="border-l">Subdistrict</div>
                        </div>

                        @foreach ($addresses->where('address_id', $country->id) as $province)
                            <div class="grid grid-cols-4">
                                <div class="border-b px-2 flex md:flex-row flex-col">
                                    <div class="place-content-center">{{ $province->name }}</div>
                                    <div class="place-content-center  ">
                                        <div class="flex">
                                            <flux:link wire:click="$dispatch('edit-address-modal',{address: '{{ $province->id }}'})" class="cursor-pointer">
                                                <flux:icon.pencil variant="micro" />
                                            </flux:link>
                                            <flux:link wire:click="$dispatch('delete-address-modal',{address: '{{ $province->id }}'})" class="text-red-500 cursor-pointer">
                                                <flux:icon.trash variant="micro" />
                                            </flux:link>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-span-3 grid grid-cols-3 border-l">
                                    @forelse ($addresses->where('address_id', $province->id) as $city)
                                        <div class="border-b px-2 flex md:flex-row flex-col">
                                            <div class="place-content-center">{{ $city->name }}</div>
                                            <div class="place-content-center  ">
                                                <div class="flex">
                                                    <flux:link wire:click="$dispatch('edit-address-modal',{address: '{{ $city->id }}'})" class="cursor-pointer">
                                                        <flux:icon.pencil variant="micro" />
                                                    </flux:link>
                                                    <flux:link wire:click="$dispatch('delete-address-modal',{address: '{{ $city->id }}'})" class="text-red-500 cursor-pointer">
                                                        <flux:icon.trash variant="micro" />
                                                    </flux:link>
                                                </div>
                                            </div>

                                        </div>
                                        <div class="border-l col-span-2 grid grid-cols-2">
                                            @forelse ($addresses->where('address_id', $city->id) as $district)
                                                <div class="border-b px-2 flex md:flex-row flex-col">
                                                    <div class="place-content-center">{{ $district->name }}</div>
                                                    <div class="place-content-center  ">
                                                        <div class="flex">
                                                            <flux:link wire:click="$dispatch('edit-address-modal',{address: '{{ $district->id }}'})" class="cursor-pointer">
                                                                <flux:icon.pencil variant="micro" />
                                                            </flux:link>
                                                            <flux:link wire:click="$dispatch('delete-address-modal',{address: '{{ $district->id }}'})" class="text-red-500 cursor-pointer">
                                                                <flux:icon.trash variant="micro" />
                                                            </flux:link>
                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="border-l border-b px-2">
                                                    @foreach ($addresses->where('address_id', $district->id) as $subdistrict)
                                                        <div class="flex md:flex-row flex-col">
                                                            <div class="place-content-center">
                                                                {{ $subdistrict->name }}
                                                            </div>
                                                            <div class="place-content-center  ">
                                                                <div class="flex">
                                                                    <flux:link wire:click="$dispatch('edit-address-modal',{address: '{{ $subdistrict->id }}'})" class="cursor-pointer">
                                                                        <flux:icon.pencil variant="micro" />
                                                                    </flux:link>
                                                                    <flux:link wire:click="$dispatch('delete-address-modal',{address: '{{ $subdistrict->id }}'})" class="text-red-500 cursor-pointer">
                                                                        <flux:icon.trash variant="micro" />
                                                                    </flux:link>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @endforeach
                                                </div>
                                            @empty
                                                <div class="border-b px-2"></div>
                                                <div class="border-l border-b px-2"></div>
                                            @endforelse
                                        </div>
                                    @empty
                                        <div class="border-b"></div>
                                        <div class="border-l border-b"></div>
                                        <div class="border-l border-b"></div>
                                    @endforelse
                                </div>
                            </div>
                        @endforeach

                        <div class="grid md:grid-cols-4 gap-4 text-center">
                            <div class="col-sapn-4 p-4"></div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </x-layouts.general-setting>
    <livewire:admin.settings.address.modal.delete-address/>
    <livewire:admin.settings.address.modal.edit-address/>
    <livewire:admin.settings.address.modal.import-address/>
</section>
