<div>
    @if ($editAddressModal)
        <flux:modal class="md:w-120 w-[90%]" wire:model="editAddressModal" :dismissible="false">
            <div class="space-y-6">
                <div>
                    <flux:heading size="lg">
                        {{ trans('Edit Address ' . $address->name) }}
                    </flux:heading>
                </div>
                <form wire:submit='updateAddress' class="space-y-6">

                    <div class="space-y-4">
                        <flux:input wire:model="input.name" :label="__('Address Name')" viewable
                            type="text" name="name" placeholder="{{ __('Input address name') }}" />
                        <flux:input wire:model="input.current_password" :label="__('user.label.confirm-password')" viewable
                            type="password" name="current_password" placeholder="{{ __('Input your password') }}" />
                    </div>

                    <div class="flex gap-2">
                        <flux:button class="cursor-pointer" variant="ghost"
                            wire:click="$set('editAddressModal', false)">
                            {{ trans('user.button.cancel') }}</flux:button>

                        <flux:button type="submit" variant="primary" color="green" icon="trash" class="cursor-pointer">
                            {{ trans('customer.button.update')}}
                        </flux:button>
                    </div>
                </form>
            </div>
        </flux:modal>
    @endif
</div>
