<div>
    <form wire:submit="update_env" class="max-w-md mt-3 space-y-4">
        <div class="grid grid-cols-4 lg:gap-2 gap-1">
            <div class="place-content-center">
                <flux:label class="font-semibold">{{ __('websystem.label.app-env') }}</flux:label>
            </div>
            <div class="col-span-3">
                <flux:select wire:model="input.app_env">
                    <flux:select.option value="local">Local</flux:select.option>
                    <flux:select.option value="production">Production</flux:select.option>
                </flux:select>
                <flux:text class="text-xs">Default: Production</flux:text>
            </div>
        </div>

        <div class="grid grid-cols-4 lg:gap-2 gap-1">
            <div class="place-content-center">
                <flux:label class="font-semibold">{{ __('websystem.label.app-debug') }}</flux:label>
            </div>
            <div class="col-span-3">
                <flux:select wire:model="input.app_debug">
                    <flux:select.option value="true">True</flux:select.option>
                    <flux:select.option value="false">False</flux:select.option>
                </flux:select>
                <flux:text class="text-xs">Default: False</flux:text>
            </div>
        </div>

        <div class="grid grid-cols-4 lg:gap-2 gap-1">
            <div class="place-content-center">
                <flux:label class="font-semibold">{{ __('websystem.label.session-driver') }}</flux:label>
            </div>
            <div class="col-span-3">
                <flux:select wire:model="input.session_driver">
                    <flux:select.option value="database">Database</flux:select.option>
                    <flux:select.option value="file">File</flux:select.option>
                </flux:select>
                <flux:text class="text-xs">Suggested: Database</flux:text>
            </div>
        </div>

        <div class="grid grid-cols-4 lg:gap-2 gap-1">
            <div class="place-content-center">
                <flux:label class="font-semibold">{{ __('websystem.label.cache-store') }}</flux:label>
            </div>
            <div class="col-span-3">
                <flux:select wire:model="input.cache_store">
                    <flux:select.option value="database">Database</flux:select.option>
                    <flux:select.option value="file">File</flux:select.option>
                </flux:select>
                <flux:text class="text-xs">Suggested: Database</flux:text>
            </div>
        </div>

        <div class="grid grid-cols-4 lg:gap-2 gap-1">
            <div class="place-content-center">
                <flux:label class="font-semibold">{{ __('websystem.label.queue-connection') }}</flux:label>
            </div>
            <div class="col-span-3">
                <flux:select wire:model="input.queue_connection">
                    <flux:select.option value="database">Database</flux:select.option>
                    <flux:select.option value="sync">Sync</flux:select.option>
                </flux:select>
                <flux:text class="text-xs">If you select Database, <a href="{{ route('helps.server-configuration.aapanel') }}" target="_blank" class="text-blue-800">make sure your server is configured</a>.</flux:text>
            </div>
        </div>

        <div class="grid grid-cols-4 lg:gap-2 gap-1">
            <div class="place-content-center">
                <flux:label class="font-semibold">{{ __('websystem.label.app-timezone') }}</flux:label>
            </div>
            <div class="co col-span-3">
                <flux:input wire:model="input.app_timezone" type="text" name="app_timezone"
                    autocomplete="app_timezone" placeholder="ex: Asia/Jakarta" />
            </div>
        </div>

        <div class="flex items-center justify-end gap-2 mt-6">
            <flux:button :href="route('helps.generalSetting')" target="_blank" variant="primary" iconTrailing="folder">
                {{ __('websystem.button.link-storage') }}
            </flux:button>
            <flux:button wire:click="optimize" variant="primary" iconTrailing="rocket-launch" class="cursor-pointer">
                {{ __('websystem.button.optimize') }}
            </flux:button>
            <flux:button type="submit" variant="primary" iconTrailing="arrow-right" class="cursor-pointer">
                {{ __('customer.button.save') }}
            </flux:button>
        </div>

    </form>

</div>
