<div>
    @if ($editUserModal)
        <flux:modal class="md:w-120 w-[90%]" wire:model="editUserModal" :dismissible="false"
            @close="$dispatch('close-edit-user-modal')">
            <div class="space-y-6">
                <div>
                    <flux:heading size="lg">
                        {{ trans('user.title.edit-user', ['user' => $userSelect->full_name]) }}
                    </flux:heading>
                    <flux:subheading>
                        {{ trans('user.title.edit-user', ['user' => $userSelect->full_name]) }}
                    </flux:subheading>
                </div>

                @if ($errors->any())
                    <flux:callout variant="danger" icon="exclamation-triangle">
                        <flux:callout.heading>Error</flux:callout.heading>
                            <flux:callout.text>
                                <ol class="list-decimal text-xs">
                                    @foreach ($errors->all() as $error)
                                        <li>
                                            {{ $error }}
                                        </li>
                                    @endforeach
                                </ol>
                            </flux:callout.text>
                    </flux:callout>
                @endif

                <form wire:submit='updateUserInformation'>
                     @if( $currentStep === 1)
                        <div class="space-y-6">
                            <div class="grid md:grid-cols-2 gap-4">
                                <flux:input :invalid="$errors->first('first_name')" wire:model="input.first_name" type="text" variant="floating" name="first_name" :label="__('user.label.first-name')"
                                autofocus autocomplete="first_name" placeholder="{{ __('user.ph.first-name') }}" />
                                <flux:input :invalid="$errors->first('last_name')" wire:model="input.last_name" type="text" variant="floating" name="last_name" :label="__('user.label.last-name')"
                                    autofocus autocomplete="last_name" placeholder="{{ __('user.ph.last-name') }}" />
                            </div>

                            <div class="grid md:grid-cols-2 gap-4">
                                <!--Gender-->
                                <flux:select :invalid="$errors->first('gender')" wire:model="input.gender" name="gender" variant="floating" :label="__('customer.label.gender')">
                                    <flux:select.option value="">{{ trans('customer.ph.select-gender') }}
                                    </flux:select.option>
                                    <flux:select.option value="male">{{ trans('customer.ph.male') }}
                                    </flux:select.option>
                                    <flux:select.option value="female">{{ trans('customer.ph.female') }}
                                    </flux:select.option>
                                </flux:select>

                                <!--DOB-->
                                <flux:input :invalid="$errors->first('dob')" wire:model="input.dob" type="date" max="2010-12-31" variant="floating" name="dob" :label="__('customer.label.dob')"/>
                            </div>

                            <div class="flex gap-2">
                                <flux:spacer />
                                <flux:modal.close>
                                    <flux:button style="cursor: pointer;" variant="ghost" wire:click="$set('editCustomerModal', false)" style="cursor: pointer">
                                        {{ trans('user.button.cancel') }}</flux:button>
                                </flux:modal.close>
                                <flux:button wire:click='firstStepSubmit' variant="primary" iconTrailing="arrow-right" style="cursor: pointer">
                                    {{ __('Next') }}
                                </flux:button>
                            </div>
                        </div>
                    @elseif($currentStep === 2)

                        <div class="space-y-6">
                            <!--Country-->
                            <livewire:components.address-select.address-model-select
                                name="country"
                                :placeholder="trans('address.select-country')"
                                :value="request('country')"
                                :searchable="true"
                                iconLeading="magnifying-glass"
                                iconLeadingSelected="map-pin"
                                iconLeadingOption="map-pin"
                                iconVariantSelected="solid"
                                iconClassSelected="text-red-500 size-5"
                            />
                            <div class="grid md:grid-cols-2 gap-4">
                                <!--Province-->
                                <livewire:components.address-select.children-address-model-select
                                    name="province"
                                    children="country"
                                    :searchable="true"
                                    :placeholder="trans('address.select-province')"
                                    :value="request('province')"
                                    :depends-on="['country']"
                                    :depends-on-values="['country' => request('country')]"
                                    iconLeading="magnifying-glass"
                                    iconLeadingSelected="check"
                                    iconVariantSelected="solid"
                                    iconClassSelected="text-green-500 size-5"
                                />
                                <!--City-->
                                <livewire:components.address-select.children-address-model-select
                                    name="city"
                                    children="province"
                                    :searchable="true"
                                    :placeholder="trans('address.select-city')"
                                    :value="request('city')"
                                    :depends-on="['province']"
                                    :depends-on-values="['province' => request('province')]"
                                    iconLeading="magnifying-glass"
                                    iconLeadingSelected="check"
                                    iconVariantSelected="solid"
                                    iconClassSelected="text-green-500 size-5"
                                />
                            </div>
                            <div class="grid md:grid-cols-2 gap-4">
                                <!--District-->
                                <livewire:components.address-select.children-address-model-select
                                    name="district"
                                    children="city"
                                    :searchable="true"
                                    :placeholder="trans('address.select-district')"
                                    :value="request('district')"
                                    :depends-on="['city']"
                                    :depends-on-values="['city' => request('city')]"
                                    iconLeading="magnifying-glass"
                                    iconLeadingSelected="check"
                                    iconVariantSelected="solid"
                                    iconClassSelected="text-green-500 size-5"
                                />
                                <!--Subdistrict-->
                                <livewire:components.address-select.children-address-model-select
                                    name="subdistrict"
                                    children="district"
                                    :searchable="true"
                                    :placeholder="trans('address.select-sub-district')"
                                    :value="request('subdistrict')"
                                    :depends-on="['district']"
                                    :depends-on-values="['district' => request('district')]"
                                    iconLeading="magnifying-glass"
                                    iconLeadingSelected="check"
                                    iconVariantSelected="solid"
                                    iconClassSelected="text-green-500 size-5"
                                />
                            </div>
                            <div class="grid md:grid-cols-2 gap-4">
                                <!--Address -->
                                <flux:input wire:model="input.address" id="address" type="text" :invalid="$errors->first('address')" variant="floating" name="address" :label="__('user.label.address')"
                                    autofocus autocomplete="address" placeholder="{{ __('customer.ph.address') }}" />
                                <!--phone -->
                                <flux:input wire:model="input.phone" id="phone" type="text" :invalid="$errors->first('phone')" autofocus autocomplete="phone" variant="floating" name="phone" :label="__('user.label.phone')"
                                    placeholder="{{ __('customer.ph.phone') }}" />
                            </div>
                            <div class="flex items-center justify-end gap-2">
                                <flux:button wire:click="back(1)" variant="primary" icon="arrow-left" class="cursor-pointer">
                                    {{ __('Back') }}
                                </flux:button>
                                <flux:button wire:click='secondStepSubmit' variant="primary" iconTrailing="arrow-right" class="cursor-pointer">
                                    {{ __('Next') }}
                                </flux:button>
                            </div>
                        </div>

                    @elseif($currentStep === 3)

                        <div class="space-y-6">
                            <flux:field>
                                <flux:select wire:model="input.role" :label="__('user.label.role')">
                                    <flux:select.option variant="">{{ trans('user.ph.select-role') }}
                                    </flux:select.option>
                                    @foreach (Spatie\Permission\Models\Role::all()->pluck('name') as $role)
                                        <flux:select.option value="{{ $role }}">{{ ucfirst($role) }}
                                        </flux:select.option>
                                    @endforeach
                                </flux:select>
                                <flux:error name="role" />
                            </flux:field>
                            <!-- Email Address -->
                            <flux:input wire:model="input.email" id="email" :label="__('Email address')" type="email"
                                name="email" autocomplete="email" placeholder="email@example.com" />

                            <!-- Password -->
                            <flux:input wire:model="input.password" id="password" :label="__('Password')" type="password"
                                name="password" autocomplete="new-password" placeholder="Password" />

                            <div class="flex items-center justify-end  gap-2">
                                <flux:button wire:click="firstStepSubmit" variant="primary" icon="arrow-left" class="cursor-pointer">
                                    {{ __('Back') }}
                                </flux:button>
                                <flux:button type="submit" variant="primary" iconTrailing="arrow-right" class="cursor-pointer">
                                    {{ __('Update') }}
                                </flux:button>
                            </div>
                        </div>
                    @endif
                </form>
            </div>

        </flux:modal>
    @endif
</div>
