<section class="w-full">
    <x-layouts.general-setting :heading="__('system.title.users')" :subheading="__('system.sub-title.users')">
        <div class="space-y-4">
            <div class="space-y-2">
                <div class="flex-col md:flex-row flex justify-between mb-2 mt-2">
                    <div class="flex justify-start gap-2">
                        <div class="mb-2 max-w-max">
                            <flux:select wire:model.live="perPage">
                                <flux:select.option value="10">Per Page 10</flux:select.option>
                            </flux:select>
                        </div>
                    </div>
                    <div class="flex justify-between gap-2">
                        <flux:button wire:click="exportUser" style="cursor: pointer;" variant="primary"
                            iconTrailing="arrow-up-right" disabled>
                            {{ __('user.button.export') }}
                        </flux:button>

                        <flux:button wire:click="$dispatch('add-user-modal')" style="cursor: pointer;" variant="primary"
                            icon="plus-circle">
                            {{ __('user.button.create') }}
                        </flux:button>
                    </div>
                </div>
                <div class="grid md:grid-cols-5 gap-2">
                    <flux:input wire:model.live.debounce.500ms="search_name_or_email" type="text"
                        placeholder="{{ trans('user.ph.search-with-name-email') }}" clearable/>
                    <flux:input wire:model.live.debounce.500ms="search_address" id="search" type="text" name="search"
                        placeholder="{{ trans('user.ph.search-with-address') }}" clearable/>
                    <flux:select wire:model.change="search_gender">
                        <flux:select.option value="">{{ trans('customer.ph.select-gender') }}
                        </flux:select.option>
                        <flux:select.option value="male">{{ trans('customer.ph.male') }}
                        </flux:select.option>
                        <flux:select.option value="female">{{ trans('customer.ph.female') }}
                        </flux:select.option>
                    </flux:select>
                </div>
            </div>

            <div wire:loading.class="opacity-75">
                <x-tables.table>
                    <x-slot name="header">
                        <x-tables.theader>
                            <x-tables.header>{{ trans('user.table.no') }}</x-tables.header>
                            <x-tables.header sortable wire:click.prevent="sortBy('full_name')"
                                :direction="$sortField === 'full_name' ? $sortDirection : null">{{ trans('user.table.full-name') }}</x-tables.header>
                            <x-tables.header sortable wire:click.prevent="sortBy('address')"
                                :direction="$sortField === 'address' ? $sortDirection : null">{{ trans('user.table.address') }}
                            </x-tables.header>
                            <x-tables.header sortable wire:click.prevent="sortBy('email')"
                                :direction="$sortField === 'email' ? $sortDirection : null">{{ trans('user.table.email') }}
                            </x-tables.header>
                            <x-tables.header>{{ trans('user.table.phone') }}</x-tables.header>
                            <x-tables.header>{{ trans('user.table.status') }}</x-tables.header>
                            <x-tables.header>{{ trans('user.table.action') }}</x-tables.header>
                        </x-tables.theader>
                    </x-slot>
                    <x-slot name="body">
                        @forelse ($users as $key => $user)
                            <x-tables.row>
                                <x-tables.cell
                                    class="text-center">{{ ($users->currentpage() - 1) * $users->perpage() + $loop->index + 1 }}</x-tables.cell>
                                <x-tables.cell>
                                    {{ $user->full_name }}
                                </x-tables.cell>

                                @php
                                    $userAddress = $user->user_address;
                                    $address = $userAddress->address?$userAddress->address.', ' : '';
                                    $subdistrict = $userAddress->subDistrict?$userAddress->subDistrict.', ' : '';
                                    $district = $userAddress->district?$userAddress->district.', ' : '';
                                    $city = $userAddress->city?$userAddress->city.', ' : '';
                                    $province = $userAddress->province?$userAddress->province.', ' : '';
                                    $country = $userAddress->country?$userAddress->country.', ' : '';
                                    $fullAddress = $address.$subdistrict.$district.$city.$province.$country;
                                @endphp
                                <x-tables.cell>
                                    {{ $fullAddress }}
                                </x-tables.cell>
                                <x-tables.cell>{{ $user->email }}</x-tables.cell>
                                <x-tables.cell>
                                    @if ($user->phone)
                                        <flux:button.group>
                                            <flux:button size="sm">
                                                {{ $user->phone }}
                                            </flux:button>
                                            <flux:button size="sm" style="cursor: pointer;"
                                                wire:click="$dispatch('disable-wa-notification-modal',{userAddress: '{{ $user->address_id }}'})">
                                                <flux:icon.wa variant="solid"
                                                    class="{{ $user->wa_notification ? 'text-green-500 dark:text-green-300' : 'text-gray-500 dark:text-gray-300' }} size-4" />
                                            </flux:button>
                                        </flux:button.group>
                                    @endif
                                </x-tables.cell>
                                <x-tables.cell class="text-center">
                                    <div class="inline-flex">
                                        <livewire:components.toogle-button :model="$user" field="disabled"
                                            dispatch="user-disable" key="{{ now() }}" />
                                        <span
                                            class="ms-2 text-sm font-medium text-gray-900 dark:text-gray-300 hidden sm:inline">
                                            @if ($user->disabled)
                                                {{ trans('system.disable') }}
                                            @else
                                                {{ trans('system.enable') }}
                                            @endif
                                        </span>
                                    </div>
                                </x-tables.cell>
                                <x-tables.cell class="text-right">
                                    <div class="flex gap-2 justify-end">
                                        <flux:button size="sm" variant="primary" icon="pencil"
                                            style="cursor: pointer;"
                                            wire:click="$dispatch('edit-user-modal', {user: '{{ $user->username }}'})" />
                                        <flux:button size="sm" variant="primary" icon="eye"
                                            style="cursor: pointer;" wire:navigate href="#}" />
                                        <flux:button size="sm" variant="primary" icon="user-circle"
                                            style="cursor: pointer;" />
                                        <flux:button size="sm" variant="danger" icon="trash" style="cursor: pointer;"
                                            wire:click="$dispatch('delete-user-modal', {user: '{{ $user->username }}'})" />
                                    </div>
                                </x-tables.cell>
                            </x-tables.row>
                        @empty
                            <x-tables.row>
                                <x-tables.cell colspan=7>
                                    <div class="flex justify-center items-center">
                                        <span class="font-medium py-8 text-gray-400 text-xl">
                                            {{ trans('user.notfound') }}
                                        </span>
                                    </div>
                                </x-tables.cell>
                            </x-tables.row>
                        @endforelse

                    </x-slot>
                </x-tables.table>
                @if ($users->hasPages())
                    <div class="p-3">
                        {{ $users->links() }}
                    </div>
                @endif
            </div>
        </div>
        <livewire:admin.users.modal.create-new-user-modal />
        <livewire:admin.users.modal.edit-user-modal />
        <livewire:admin.users.modal.delete-user-modal />
        <livewire:admin.users.modal.disable-wa-notification />
    </x-layouts.general-setting>
</section>
