<section class="w-full">

    <x-layouts.general-setting>
       <x-slot name="menu">
            <x-layouts.whatsapp-gateway.nav-bar-message/>
        </x-slot>
        <div class="my-6 w-full space-y-6">
            <div class="flex justify-end">
                @if ($messageHistories->count() > 1)
                    <flux:button size="sm" variant="danger" icon="trash" wire:click="$dispatch('confirm-delete-all-modal')" class="cursor-pointer">
                        Delete All
                    </flux:button>
                @endif

            </div>
            <div wire:loading.class="opacity-75" class="relative overflow-x-auto ">
                <x-tables.table class="table-fixed">
                    <x-slot name="header">
                        <x-tables.theader>
                            <x-tables.header>{{ trans('whatsapp-gateway.table.no') }}</x-tables.header>
                            <x-tables.header>{{ trans('Sender') }}</x-tables.header>
                            <x-tables.header>{{ trans('Receive') }}</x-tables.header>
                            <x-tables.header>{{ trans('Message') }}</x-tables.header>
                            <x-tables.header>{{ trans('Status') }}</x-tables.header>
                            <x-tables.header>{{ trans('Note') }}</x-tables.header>
                            <x-tables.header>{{ trans('Time') }}</x-tables.header>
                            <x-tables.header>{{ trans('From') }}</x-tables.header>
                            <x-tables.header>{{ trans('whatsapp-gateway.table.action') }}</x-tables.header>
                        </x-tables.theader>
                    </x-slot>
                    <x-slot name="body">
                        @forelse ($messageHistories as $key => $messageHistory)
                        @php
                            $country_code = \App\Models\WhatsappGateway\WhatsappGatewayGeneral::first()->country_code;
                            $customerName = preg_replace('/^' . $country_code . '?/', 0, $messageHistory['receiver'] ?? 0);

                            $userAddress = \App\Models\UserAddress::wherePhone($customerName)->orWhere('phone', $messageHistory['receiver'])->first();

                            if ($userAddress) {
                                $customerName = $userAddress->user->full_name;
                            } else {
                                $customerPaketAddress = \App\Models\Customers\CustomerPaketAddress::wherePhone($customerName)->orWhere('phone', $messageHistory['receiver'])->first();
                                if ($customerPaketAddress) $customerName = $customerPaketAddress->customer_paket->user->full_name;
                            }
                        @endphp
                            <x-tables.row>
                                <x-tables.cell
                                    class="text-center">{{ ($messageHistories->currentpage() - 1) * $messageHistories->perpage() + $loop->index + 1 }}</x-tables.cell>
                                <x-tables.cell> {{ $messageHistory['device'] ?? '' }}</x-tables.cell>
                                <x-tables.cell>{{ $customerName }}</x-tables.cell>
                                <x-tables.cell> {{ $messageHistory['message'] ?? '' }}</x-tables.cell>
                                <x-tables.cell class="text-center">
                                    <flux:badge size="sm" :color="$messageHistory['status'] == 4 ? 'indigo' : ($messageHistory['status'] == 3 ? 'emerald' : ($messageHistory['status'] == 1 || $messageHistory['status'] == 2 ? 'amber' : 'rose'))"
                                        :icon="$messageHistory['status'] == 4 ? 'check-badge' : ($messageHistory['status'] == 3 ? 'check' : ($messageHistory['status'] == 1 || $messageHistory['status'] == 2 ? 'clock' : 'x-circle'))">
                                     {{  $messageHistory['status'] == 4 ? 'Read' : ($messageHistory['status'] == 3 ? 'Sent' : ($messageHistory['status'] == 1 || $messageHistory['status'] == 2 ? 'Pending' : 'Unsent')) }}
                                    </flux:badge>
                                </x-tables.cell>
                                <x-tables.cell class="text-center"> {{ $messageHistory['note'] ?? '' }}</x-tables.cell>
                                <x-tables.cell class="text-center"> {{ $messageHistory['updated_at'] ?? '' }}</x-tables.cell>
                                <x-tables.cell class="text-center"> {{ $messageHistory['send_from'] ?? '' }}</x-tables.cell>
                                <x-tables.cell>
                                    <flux:tooltip content="Delete">
                                    <flux:button size="sm" variant="danger" icon="trash" wire:click="$dispatch('confirm-delete-modal', {id: '{{ $messageHistory['id'] }}'})" class="cursor-pointer"/>
                                    </flux:tooltip>
                                </x-tables.cell>
                            </x-tables.row>
                        @empty
                            <x-tables.row>
                                <x-tables.cell colspan=9>
                                    <div class="flex justify-center items-center">
                                        <span class="font-medium py-8 text-gray-400 text-xl">
                                            {{ trans('Anda belum memiliki pesan') }}
                                        </span>
                                    </div>
                                </x-tables.cell>
                            </x-tables.row>
                        @endforelse
                    </x-slot>
                </x-tables.table>
                @if ($messageHistories->hasPages())
                    <div class="p-3">
                        {{ $messageHistories->links() }}
                    </div>
                @endif


            </div>
    </x-layouts.whatsapp-gateway.layout>
    <livewire:admin.whatsapp-gateway.modal.confirm-delete/>
    <livewire:admin.whatsapp-gateway.modal.confirm-delete-all/>
</section>
