<div>
    @if ($confirmDeleteModal)
    <flux:modal class="md:w-120 w-[90%]" wire:model="confirmDeleteModal" :dismissible="false">
        <div class="space-y-6">
            <div>
                <flux:heading size="lg">
                    Delete
                </flux:heading>
                <flux:subheading>
                    Are you sure to delete?
                </flux:subheading>
            </div>

            <form wire:submit="delete_this" class="space-y-6">
                <div class="space-y-4">
                    <flux:input wire:model="input.current_password" :label="__('Enter your password')"
                        type="password" name="current_password" placeholder="{{ __('Enter your current password') }}" viewable/>
                </div>
                <div class="flex items-center justify-end">
                    <flux:button wire:click="$set('confirmDeleteModal', false)" variant="ghost" class="me-2"
                        style="cursor:pointer">
                        {{ __('device.button.cancel') }}
                    </flux:button>
                    <flux:button icon="trash" variant="danger" style="cursor:pointer" type="submit">
                        {{ __('device.button.delete') }}
                    </flux:button>
                </div>
            </form>
        </div>
    </flux:modal>
    @endif
</div>
