<section class="w-full">
    @php
        $company = \App\Models\Websystem::first();

        $companyName = $company->name ? $company->name : env('APP_NAME');

        $address = $company->address ? $company->address . ', ' : '';
        $subdistrict = $company->subdistrict ? $company->subdistrict . ', ' : '';
        $district = $company->district ? $company->district . ', ' : '';
        $city = $company->city ? $company->city . ', ' : '';
        $province = $company->province ? $company->province . ', ' : '';
        $postalCode = $company->postal_code ? ' - ' . $company->postal_code : '';
        $companyAddress =  $address . $subdistrict . $district . $city . $province . $postalCode;

        $country_code = \App\Models\WhatsappGateway\WhatsappGatewayGeneral::first()->country_code;
        $companyPhone = $company->phone ? preg_replace('/^' . $country_code . '?/', 0, $company->phone) : '';
    @endphp
    <x-layouts.general-setting>
        <x-slot name="menu">
            <x-layouts.whatsapp-gateway.nav-bar-message/>
        </x-slot>
        <div class="my-6 w-full space-y-6">
            <!--Button-->
            <div class="flex justify-end">
                <flux:button size="sm" wire:click="$dispatch('show-reset-notification-message-modal')"
                    style="cursor: pointer;" variant="danger" icon="arrow-path-rounded-square">
                    {!! trans('billing.button.reset-message') !!}
                </flux:button>
            </div>

             @if ($notificationMessages->hasPages())
                <div class="p-3">
                    {{ $notificationMessages->links() }}
                </div>
            @endif

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6" wire:loading.class="opacity-75">
                @forelse ($notificationMessages as $key => $message)
                    <div class="border rounded-lg py-2 px-4 bg-white">
                        <div class="flex justify-between md:flex-col flex-row gap-2">
                            <div class="justify-start">
                            <flux:button size="sm" variant="outline" icon="pencil" class="cursor-pointer" wire:click="$dispatch('show-edit-notification-message-modal',{message: '{{ $message['id'] }}'})" title="{{ trans('Edit Message') }}">
                                {{ $message->name }}
                            </flux:button>
                            </div>
                            <div class="justify-between">
                                <livewire:components.toogle-button dispatch="refresh-notification-message" :model="$message" field="disabled" key="{{ now() }}" />
                            </div>
                        </div>
                        <flux:text class="mt-2">{{ $message->description }}</flux:text>
                        @php
                            $replace = [
                                '%company_name%' => env('APP_NAME'),
                                '%gender%' => auth()->user()->user_admin->gender ? (auth()->user()->user_admin->gender === 'male' ? 'Bp. ' : 'Ibu. ') : 'Bp/Ibu ',
                                '%name%' =>  auth()->user()->full_name,
                                '%email%' => auth()->user()->email,
                                '%address%' => auth()->user()->user_address->address,
                                '%customer_id%' => auth()->user()->id,
                                '%invoice_number%' => '[INV-12345678]',
                                '%transaction_id%' =>  '[TR-12345678]',
                                '%paket%' => '[Nama Paket, Harga Paket]',
                                '%periode%' =>  \Carbon\Carbon::now()->startOfMonth()->format('d F Y - ') . \Carbon\Carbon::now()->endOfMonth()->format('d F Y'),
                                '%bill%' => '[Rp.' . number_format(123456, 2).']',
                                '%teller%' => auth()->user()->full_name,
                                '%payment_time%' =>  Carbon\Carbon::now()->format('d F Y H:i:s'),
                                '%payment_methode%' => '[Cash]',
                                '%company_address%' => $companyAddress,
                                '%company_phone%' => $companyPhone,
                                '%cs_name%' => auth()->user()->full_name,
                                '%cs_contact%' => $companyPhone,
                                '%paket_name%' => '[Nama Paket Active]',
                                '%paket_price%' => 'Rp.' . number_format(123456, 2),
                                '%count_bill%' => 2,
                                '%total_bill%' => 'Rp.' . number_format(123456, 2),
                                '%status%' => '[Active/Isolir]',
                                '%connection_status%' => '[Up/Down]',
                                '%account_bank%' => '[Akun Bank Terdaftar]',
                                '%installation_address%' => $companyAddress,
                                '%pakets%' => '[Detail Paket Customer]',
                                '%status_admin%' => '[Active/Isolir]',
                                '%refund_payment%' => 'Rp.' . number_format(123456, 2),
                                '%customer_bank_account%' => '[Rekening Pengembalian Customer]',
                                '%customer_bills%' => '[1. '.auth()->user()->full_name.']',
                                '%customer_isolirs%' => '[1. '.auth()->user()->full_name.']',
                            ];
                            $notificationMessage =  str_replace(array_keys($replace), $replace, $message['message']);
                        @endphp
                        <x-whatsapp-preview :send_message="$notificationMessage" />
                    </div>
                @empty
                    <flux:callout icon="envelope" color="zinc">
                        <flux:callout.heading>{{ trans('whatsapp-gateway.notification-message-notfound') }}</flux:callout.heading>
                    </flux:callout>
                @endforelse
            </div>

            @if ($notificationMessages->hasPages())
                <div class="p-3">
                    {{ $notificationMessages->links() }}
                </div>
            @endif
        </div>
    </x-layouts.whatsapp-gateway.layout>
    <livewire:admin.whatsapp-gateway.modal.notification-message.edit-notification-message />
    <livewire:admin.whatsapp-gateway.modal.notification-message.reset-messages />
</section>
