<section class="w-full">
    <x-layouts.general-setting :heading="__('Whatsapp Gateway')" :subheading="__('Connect your aplication to whatsapp gateway')">
        <x-slot name="menu">
            <x-layouts.whatsapp-gateway.nav-bar/>
        </x-slot>
        @if ($siteOnline)
            <div class="flex flex-col gap-4 mt-2">
                @foreach ($notifications as $notification)
                    <flux:callout variant="warning" :icon="$notification['icon'] ?? 'information-circle'">
                        <flux:callout.heading>{{ $notification['title'] }}</flux:callout.heading>
                        <flux:callout.text>
                            {{ $notification['message'] }}
                        </flux:callout.text>
                    </flux:callout>
                @endforeach
            </div>

            @if ($isLogin)
                <div class="md:mt-4 mt-2 flex flex-col  bg-white border border-gray-200 rounded-lg shadow-sm md:flex-row hover:bg-gray-100 dark:border-gray-700 dark:bg-gray-800 dark:hover:bg-gray-700">
                    <div class="object-cover flex p-4 items-center w-full rounded-t-lg h-auto md:h-auto md:w-48 md:rounded-none md:rounded-s-lg  {{ $subscription ? ($subscription['status'] == 'active' ? 'bg-green-500' : 'bg-red-600') : 'bg-red-600' }}">
                        <img src="http://{{ config('wa-griyanet.server_url') }}/assets/images/logo_black.png" height="50px" alt="griyanet whatsapp gateway"/>
                    </div>

                    <div class="flex flex-col justify-between p-4 leading-normal w-full gap-2">
                        <div class="grid grid-cols-3">
                            <flux:heading>{{ trans('whatsapp-gateway.label.email') }}</flux:heading>
                            <div class="col-span-2">
                                <flux:subheading>{{ $user['email'] }}</flux:subheading>
                            </div>
                        </div>
                        <div class="grid grid-cols-3">
                            <flux:heading>{{ trans('whatsapp-gateway.label.username') }}</flux:heading>
                            <div class="col-span-2">
                                <flux:subheading>{{ $user['username'] }}</flux:subheading>
                            </div>
                        </div>

                        <div class="grid grid-cols-3">
                            <flux:heading>{{ trans('whatsapp-gateway.label.subscription-status') }}</flux:heading>
                            <div class="col-span-2">
                                <flux:badge color="{{ $subscription ? ($subscription['status'] == 'active' ? 'emerald' : 'rose') : 'red' }}">
                                    {{Str::apa($subscription['status'] ?? 'In Active')}}
                                </flux:badge>
                            </div>
                        </div>

                        <div class="grid grid-cols-3">
                            <flux:heading>{{ trans('whatsapp-gateway.label.subscription') }}</flux:heading>
                            <div class="flex flex-row gap-2 col-span-2">
                                @if ($subscription)
                                    <flux:subheading>
                                        {{Str::apa($subscription['product_name'].' - '.$subscription['renewal_period'] ?? 'Unsubscribe')}}
                                    </flux:subheading>

                                    <flux:button variant="primary" size="xs"
                                    icon="pencil" style="cursor: pointer;"
                                    wire:click="$dispatch('show-edit-subscription-modal', {subscription: '{{ $subscription['slug'] }}'})">
                                        Upgrade
                                    </flux:button>

                                @else
                                <flux:button variant="primary" size="xs"
                                    icon="plus-circle" style="cursor: pointer;"
                                    wire:click="$dispatch('show-add-subscription-modal')">
                                    Add
                                </flux:button>
                                @endif

                            </div>
                        </div>

                        <div class="grid grid-cols-3">
                            <flux:heading>{{ trans('whatsapp-gateway.label.subscription-expired') }}</flux:heading>
                            <div class="col-span-2">
                                @if ($subscription)
                                    <flux:subheading>
                                        {{ \Carbon\Carbon::parse($subscription['end_date'])->diffForHumans() }}
                                    </flux:subheading>
                                @endif
                            </div>
                        </div>

                        <div class="grid grid-cols-3">
                            <flux:heading>{{ __('whatsapp-gateway.label.remaining-day') }}</flux:heading>

                            <div class="text-sm text-zinc-500 dark:text-white/70 col-span-2">
                                <div class="flex gap-2">
                                    <div>
                                        <flux:input.group>
                                            <flux:input wire:model.blur="input.remaining_day" type="text" name="remaining_day"
                                                autofocus autocomplete="remaining_day"
                                                placeholder="{{ __('whatsapp-gateway.helper.remaining-day') }}" />
                                            <flux:input.group.suffix>{{ __('whatsapp-gateway.label.day') }}</flux:input.group.suffix>
                                        </flux:input.group>
                                    </div>
                                    <x-action-message class="me-3 p-1" on="remaining-day-updated">
                                        <flux:badge color="teal">Saved</flux:badge>
                                    </x-action-message>
                                </div>
                                <flux:error name="remaining_day" />
                            </div>
                        </div>

                        <div class="grid grid-cols-3">
                            <flux:heading>{{ __('whatsapp-gateway.label.schedule-time') }}</flux:heading>
                            <div class="text-sm text-zinc-500 dark:text-white/70 colspan-2">
                                <div class="flex gap-2">
                                    <flux:input type="time" wire:model.blur="input.schedule_time"/>
                                    <x-action-message class="me-3 p-1" on="schedule-time-updated">
                                        <flux:badge color="teal">Saved</flux:badge>
                                    </x-action-message>
                                </div>
                                <flux:error name="schedule_time" />
                            </div>
                        </div>

                        <div class="grid grid-cols-3">
                            <flux:heading>{{ __('Country Code Number') }}</flux:heading>
                            <div class="text-sm text-zinc-500 dark:text-white/70 flex gap-2 colspan-2">
                                <flux:field>
                                    <flux:input wire:model.blur="input.country_code_number"
                                        name="country_code_number" placeholder="ex: 62"/>
                                    <flux:error name="country_code_number" />
                                </flux:field>
                                <x-action-message class="me-3 p-1" on="country-code-number-updated">
                                    <flux:badge color="teal">Saved</flux:badge>
                                </x-action-message>

                            </div>
                        </div>

                        <div class="grid grid-cols-3">
                            <flux:heading>{{ __('whatsapp-gateway.label.whatsapp-number-boot') }}</flux:heading>
                            <div class="text-sm text-zinc-500 dark:text-white/70 flex gap-2 colspan-2">
                                <flux:field>
                                    <flux:select wire:model.change="input.whatsapp_number_boot" name="whatsapp_number_boot">
                                        <flux:select.option value="">
                                            {{ trans('whatsapp-gateway.ph.select-wa-number') }}
                                        </flux:select.option>
                                        @foreach ($devices as $device)
                                            <flux:select.option value="{{ $device['body'] }}">{{ $device['body'] }}
                                            </flux:select.option>
                                        @endforeach
                                    </flux:select>
                                    <flux:error name="whatsapp_number_boot" />
                                </flux:field>
                                <x-action-message class="me-3 p-1" on="boot-number-updated">
                                    <flux:badge color="teal">Saved</flux:badge>
                                </x-action-message>
                                <x-action-message class="me-3 p-1" on="boot-number-failed-updated">
                                    <flux:badge color="teal">Failed</flux:badge>
                                </x-action-message>
                            </div>
                        </div>

                        <div class="grid grid-cols-3">
                            <flux:heading>{{ __('whatsapp-gateway.label.whatsapp-number-notification') }}</flux:heading>
                            <div class="text-sm text-zinc-500 dark:text-white/70 flex gap-2 colspan-2">
                                <flux:field>
                                    <flux:select wire:model.change="input.whatsapp_number_notification"
                                        name="whatsapp_number_notification">
                                        <flux:select.option value="">
                                            {{ trans('whatsapp-gateway.ph.select-wa-number') }}
                                        </flux:select.option>
                                        @foreach ($devices as $device)
                                            <flux:select.option value="{{ $device['body'] }}">{{ $device['body'] }}
                                            </flux:select.option>
                                        @endforeach
                                    </flux:select>
                                    <flux:error name="whatsapp_number_notification" />
                                </flux:field>
                                <x-action-message class="me-3 p-1" on="notification-number-updated">
                                    <flux:badge color="teal">Saved</flux:badge>
                                </x-action-message>

                            </div>
                        </div>

                        <div class="grid grid-cols-3">
                            <flux:heading>{{ __('whatsapp-gateway.label.enable') }}</flux:heading>
                            <div class="text-sm text-zinc-500 dark:text-white/70 colspan-2">
                                <flux:field variant="inline">
                                    <flux:checkbox wire:model.live="enable" />
                                    @if ($enable)
                                        <flux:label>
                                            <flux:badge color="lime">
                                                {{ trans('whatsapp-gateway.label.whatsapp-gateway-enable') }}</flux:badge>
                                        </flux:label>
                                    @else
                                        <flux:label>
                                            <flux:badge color="rose">
                                                {{ trans('whatsapp-gateway.label.whatsapp-gateway-disable') }}</flux:badge>
                                        </flux:label>
                                    @endif
                                </flux:field>
                            </div>
                        </div>


                        <div class="grid grid-cols-3">
                            <flux:heading>{{ __('whatsapp-gateway.label.notif-admin') }}</flux:heading>
                            <div class="text-sm text-zinc-500 dark:text-white/70 colspan-2">
                                <flux:field variant="inline">
                                    <flux:checkbox wire:model.live="notifAdmin" />
                                    @if ($notifAdmin)
                                        <flux:label>
                                            <flux:badge color="lime">{{ trans('whatsapp-gateway.label.yes') }}
                                            </flux:badge>
                                        </flux:label>
                                    @else
                                        <flux:label>
                                            <flux:badge color="rose">{{ trans('whatsapp-gateway.label.no') }}
                                            </flux:badge>
                                        </flux:label>
                                    @endif
                                </flux:field>
                            </div>
                        </div>
                    </div>
                </div>
            @else
                <div class="w-full p-4 text-center sm:p-8">
                    <div
                        class="items-center justify-center space-y-4 sm:flex sm:space-y-0 sm:space-x-4 rtl:space-x-reverse">
                        <div
                            class="w-full max-w-sm p-4 bg-white border border-gray-200 rounded-lg shadow-sm sm:p-6 md:p-8 dark:bg-gray-800 dark:border-gray-700">

                            <form wire:submit="initialize">
                                <div class="space-y-6" action="#">
                                    @if (empty(env('API_USERNAME')) || empty(env('API_CLIENT_SECRET')) || empty(env('API_CLIENT_MESSAGE')))
                                        <h5 class="text-xl font-medium text-gray-900 dark:text-white">Register</h5>
                                        <p class="mb-5 text-base text-gray-500 sm:text-sm dark:text-gray-400">
                                            You dont have account on Griyanet Whatsapp Gateway or data corrupt. Please
                                            syncronize
                                            now.</p>
                                    @else
                                        <h5 class="text-xl font-medium text-gray-900 dark:text-white">Login</h5>
                                        <p class="mb-5 text-base text-gray-500 sm:text-sm dark:text-gray-400">
                                            Please login with email on General Setting and your password registration to continue.</p>
                                    @endif
                                    <flux:error name="email"/>

                                    <div>
                                        <flux:input wire:model="input.password" type="password" name="passsword"
                                            autocomplete="password"
                                            placeholder="{{ __('Password registration') }}" />
                                        <flux:error class="mt-1" name="password" />
                                    </div>

                                    <flux:button variant="primary" size="sm" icon="arrow-right-circle"
                                        style="cursor: pointer;" type="submit">
                                        {{ empty(env('API_USERNAME')) || empty(env('API_CLIENT_SECRET')) || empty(env('API_CLIENT_MESSAGE'))
                                            ? trans('whatsapp-gateway.button.register')
                                            : trans('whatsapp-gateway.button.login') }}
                                    </flux:button>

                                    <div>
                                        <x-action-message class="me-3" on="login-success">
                                            {{ __('Login successfully') }}
                                        </x-action-message>
                                    </div>
                                    <flux:text>
                                    Read this <flux:button size="sm" variant="ghost" icon="book-open-text"><a href="{{ route('helps.whatsapps.subscription') }}" target="_blank">document</a></flux:button> to registration.
                                    </flux:text>
                                </div>
                            </form>

                        </div>
                    </div>
                </div>
            @endif

        @else
            <flux:callout variant="danger" icon="exclamation-triangle">
                <flux:callout.heading>Something went wrong. Try again or contact support.</flux:callout.heading>
                <flux:callout.text>
                    We couldn't connect to the griyanet server. Please Try again or <flux:callout.link :external="true" href="https://wa.me/6285726455588?text=Griyanet%20Server%20tidak%20dapat%20diakses.">contact support</flux:callout.link>.
                </flux:callout.text>
            </flux:callout>
         @endif
         <div
            class="relative overflow-hidden rounded-xl border border-neutral-200 dark:border-neutral-700 p-6 mt-2">
            <flux:badge color="sky" class="mb-2">Document</flux:badge><br>
            Read this <flux:button size="sm" icon="book-open-text"><a href="{{ route('helps.whatsapps.generalConfig') }}" target="_blank">document</a></flux:button> to configuration.
        </div>

    </x-layouts.whatsapp-gateway.layout>
    <livewire:admin.whatsapp-gateway.modal.edit-subscription />
</section>
