<div class="space-y-6">
    <x-auth-header :title="\App\Models\Websystem::first()->title ?? env('APP_NAME')"
        :description="__('Enter your details below to create your account')" />

    <!-- Session Status -->
    <x-auth-session-status class="text-center" :status="session('status')" />
    <form wire:submit="register_step_one" class="space-y-6">
        <!-- First Name -->
        <flux:input wire:model="input.first_name" id="first_name" :label="__('customer.label.first-name')"
            type="text" name="first_name" autofocus autocomplete="first_name"
            placeholder="{{ __('customer.ph.first-name') }}" />

        <!--Last Name -->
        <flux:input wire:model="input.last_name" id="last_name" :label="__('customer.label.last-name')" type="text"
            name="last_name" autofocus autocomplete="last_name" placeholder="{{ __('customer.ph.last-name') }}" />

        <!--Gender-->
        <flux:field>
            <flux:select wire:model="input.gender" :label="__('customer.label.gender')">
                <flux:select.option variant="">{{ trans('customer.ph.select-gender') }}</flux:select.option>
                <flux:select.option value="male">{{ trans('customer.ph.male') }}</flux:select.option>
                <flux:select.option value="female">{{ trans('customer.ph.female') }}</flux:select.option>
            </flux:select>
            <flux:error name="gender" />
        </flux:field>

        <!--DOB-->
        <flux:field>
            <flux:label>{{ __('customer.label.dob') }}</flux:label>
            <flux:input placeholder="{{ __('customer.ph.dob') }}" id="dob" wire:model="input.dob" type="text"
                x-ref="datepicker" x-init="new Pikaday({
                    field: document.getElementById('dob'),
                    format: 'YYYY-MM-DD',
                    toString(date, format) {
                        const day = String(date.getDate()).padStart(2, 0);
                        const month = String(date.getMonth() + 1).padStart(2, 0);
                        const year = date.getFullYear();
                        return `${day}/${month}/${year}`;
                    },
                    minDate: new Date(1950, 0, 1),
                    maxDate: new Date(2009, 11, 31),
                    yearRange: [1950, 2009],
                    defaultDate: new Date(2009, 11, 31),
                    onSelect: function() {
                        $wire.$set('input.dob', moment(this.getDate()).format('DD MMMM YYYY'), false);
                    }
                })" />
            <flux:error name="dob" />
        </flux:field>
        <div class="flex items-center justify-end">
            <flux:button type="submit" variant="primary" color='orange' size="sm">
                {{ __('Next') }}
            </flux:button>
        </div>
    </form>
    <div class="space-x-1 rtl:space-x-reverse text-center text-sm text-zinc-600 dark:text-zinc-400">
        {{ __('Already have an account?') }}
        <flux:link :href="route('login')" wire:navigate>{{ __('Log in') }}</flux:link>
    </div>
</div>
