<div class="space-y-6">
    <x-auth-header :title="\App\Models\Websystem::first()->title ?? env('APP_NAME')" :description="__('Enter your details below to create your account')" />

    <!-- Session Status -->
    <x-auth-session-status class="text-center" :status="session('status')" />
    <form wire:submit="add_address" class="space-y-6">
        <!--Country-->
        <livewire:components.address-select.address-model-select
            name="country"
            :placeholder="trans('address.select-country')"
            :value="request('country')"
            :searchable="true"
            iconLeading="magnifying-glass"
            iconLeadingSelected="map-pin"
            iconLeadingOption="map-pin"
            iconVariantSelected="solid"
            iconClassSelected="text-red-500 size-5"
        />
        <div class="grid md:grid-cols-2 gap-4">
            <!--Province-->
            <livewire:components.address-select.children-address-model-select
                name="province"
                children="country"
                :searchable="true"
                :placeholder="trans('address.select-province')"
                :value="request('province')"
                :depends-on="['country']"
                :depends-on-values="['country' => request('country')]"
                iconLeading="magnifying-glass"
                iconLeadingSelected="check"
                iconVariantSelected="solid"
                iconClassSelected="text-green-500 size-5"
            />
            <!--City-->
            <livewire:components.address-select.children-address-model-select
                name="city"
                children="province"
                :searchable="true"
                :placeholder="trans('address.select-city')"
                :value="request('city')"
                :depends-on="['province']"
                :depends-on-values="['province' => request('province')]"
                iconLeading="magnifying-glass"
                iconLeadingSelected="check"
                iconVariantSelected="solid"
                iconClassSelected="text-green-500 size-5"
            />
        </div>
        <div class="grid md:grid-cols-2 gap-4">
            <!--District-->
            <livewire:components.address-select.children-address-model-select
                name="district"
                children="city"
                :searchable="true"
                :placeholder="trans('address.select-district')"
                :value="request('district')"
                :depends-on="['city']"
                :depends-on-values="['city' => request('city')]"
                iconLeading="magnifying-glass"
                iconLeadingSelected="check"
                iconVariantSelected="solid"
                iconClassSelected="text-green-500 size-5"
            />
            <!--Subdistrict-->
            <livewire:components.address-select.children-address-model-select
                name="subdistrict"
                children="district"
                :searchable="true"
                :placeholder="trans('address.select-sub-district')"
                :value="request('subdistrict')"
                :depends-on="['district']"
                :depends-on-values="['district' => request('district')]"
                iconLeading="magnifying-glass"
                iconLeadingSelected="check"
                iconVariantSelected="solid"
                iconClassSelected="text-green-500 size-5"
            />
        </div>
        <div class="grid md:grid-cols-2 gap-4">
            <!--Address -->
            <flux:input wire:model="input.address" id="address" type="text" :invalid="$errors->first('address')" variant="floating" name="address" :label="__('user.label.address')"
                autofocus autocomplete="address" placeholder="{{ __('customer.ph.address') }}" />
            <!--phone -->
            <flux:input wire:model="input.phone" id="phone" type="text" :invalid="$errors->first('phone')" autofocus autocomplete="phone" variant="floating" name="phone" :label="__('user.label.phone')"
                placeholder="{{ __('customer.ph.phone') }}" />
        </div>
        <div class="flex items-center justify-end">
            <flux:button wire:click="back_step_one" variant="primary" size="sm" class="me-2">
                {{ __('Back') }}
            </flux:button>
            <flux:button type="submit" variant="primary" color='orange' size="sm">
                {{ __('Next') }}
            </flux:button>
        </div>
    </form>
    <div class="space-x-1 text-center text-sm text-zinc-600 dark:text-zinc-400">
        {{ __('Already have an account?') }}
        <flux:link :href="route('login')" wire:navigate>{{ __('Log in') }}</flux:link>
    </div>
</div>
