<div class="md:flex justify-center">
    <div class="md:w-120">
        <div class="space-y-4">
            @forelse ($invoices as $invoice)
                <flux:callout icon="bell-alert" :variant="$invoice->order ? ($invoice->order->status == 'paid' ? 'success' : 'warning') : ($invoice->status == 'paid' ? 'success' : 'warning')">
                    <flux:callout.heading>
                        @if ($invoice->status === 'paid')
                            Dibayar {{ \Carbon\Carbon::parse($invoice->paid_at)->format('d M Y H:i') }}
                        @else
                            @if ($invoice->order)
                                {{ $invoice->order->status == 'paid' ? $invoice->order->status : 'Kadaluarsa pada ' . \Carbon\Carbon::parse($invoice->order->expired_time)->format('d M Y H:i') }}
                            @else
                                Batas akhir pembayaran {{ \Carbon\Carbon::parse($invoice->due_date)->format('d M Y') }}
                            @endif
                        @endif

                    </flux:callout.heading>

                    <div class="space-y-2">
                        <div class="flex justify-between md:flex-row flex-col">
                            <div class="flex justify-start">
                                <flux:heading>Langganan</flux:heading>
                            </div>
                            <div class="flex justify-between">
                                <flux:heading>
                                    {{ $invoice->customer_paket->paket->name }}
                                </flux:heading>
                            </div>
                        </div>
                        <div class="flex justify-between md:flex-row flex-col">
                            <div class="flex justify-start">
                                <flux:heading>Lokasi Pemasangan</flux:heading>
                            </div>
                            <div class="flex justify-between">
                                <flux:text>
                                    {{ $invoice->customer_paket->full_customer_installation_address }}
                                </flux:text>
                            </div>
                        </div>

                        <flux:separator/>
                        @if ($invoice->status === 'paid')
                            <div class="flex justify-between md:flex-row flex-col">
                                <div class="flex justify-start">
                                    <flux:heading>Jumlah Bayar</flux:heading>
                                </div>
                                <div class="flex justify-between">
                                    @php
                                        $totalPaid = $invoice->payments->sum('amount');
                                        $totalRefunded = $invoice->payments->sum('refunded_amount');
                                        $netPaid = $totalPaid - $totalRefunded;
                                    @endphp
                                    <flux:heading>@moneyIDR($netPaid)</flux:heading>
                                </div>
                            </div>
                        @else
                            <div class="flex justify-between md:flex-row flex-col">
                                <div class="flex justify-start">
                                    <flux:heading>Periode</flux:heading>
                                </div>
                                <div class="flex justify-between">
                                    <flux:text>
                                    {{ \Carbon\Carbon::parse($invoice->start_periode)->format('d M Y') }} - {{ \Carbon\Carbon::parse($invoice->end_periode)->format('d M Y') }}
                                    </flux:text>
                                </div>
                            </div>
                            <div class="flex justify-between md:flex-row flex-col">
                                <div class="flex justify-start">
                                    <flux:heading>Total Tagihan</flux:heading>
                                </div>
                                <div class="flex justify-between">
                                    @php
                                        $totalInvoice = $invoice->amount - $invoice->discount + $invoice->tax;
                                    @endphp
                                    <flux:text>@moneyIDR($totalInvoice)</flux:text>
                                </div>
                            </div>
                            <div class="flex justify-between md:flex-row flex-col">
                                <div class="flex justify-start">
                                    <flux:heading>Total Harus Bayar</flux:heading>
                                </div>
                                <div class="flex justify-between">
                                    @php
                                        $totalPaid = $invoice->payments->sum('amount');
                                        $totalRefunded = $invoice->payments->sum('refunded_amount');
                                        $netPaid = $totalPaid - $totalRefunded;
                                        $paid = $invoice->amount - $netPaid;
                                    @endphp
                                    <flux:heading>@moneyIDR($paid)</flux:heading>
                                </div>
                            </div>
                        @endif
                    </div>

                    <flux:separator class="mt-2 mb-2" />
                    <div class="flex items-center justify-end gap-2">
                        @if ($invoice->status != 'paid')
                            @if ($activePaymentGateway->count())
                                <flux:button size='sm'
                                    wire:click="$dispatch('show-create-order-modal', {invoice: '{{ $invoice->id }}'})"
                                    variant="primary" style="cursor: pointer">Bayar
                                </flux:button>
                            @else
                                <flux:text>Saat ini belum tersedia pembayaran online, namun anda masih bisa melakukan
                                    pembayaran melalui direct transfer atau datang ke outlet terdekat kami.</flux:text>
                            @endif
                        @else
                            @if ($invoice->order)
                                <flux:button size='sm'
                                    wire:click="$dispatch('show-detail-order-paid-modal', {order: '{{ $invoice->order->id }}'})"
                                    variant="primary" style="cursor: pointer">Lihat Detail Pembayaran
                                </flux:button>
                            @endif
                        @endif

                    </div>
                </flux:callout>
            @empty
                <flux:callout icon="check-circle" variant="primary" color="green">
                    <flux:callout.heading>
                        Informasi Tagihan
                    </flux:callout.heading>

                    <flux:callout.text>
                        Anda belum memiliki tagihan.
                    </flux:callout.text>
                </flux:callout>
            @endforelse
        </div>

        @if ($invoices->hasPages())
            <div class="p-3">
                {{ $invoices->links() }}
            </div>
        @endif
        <livewire:customer.billing.modal.create-order />
        <livewire:customer.billing.modal.view-detail-order-paid />
    </div>
</div>

