<section class="w-full">
    @include('partials.settings-heading')

    <x-settings.layout :heading="__('Profile')" :subheading="__('Update your profile information')">
        @if ($errors->any())
            <flux:callout variant="danger" icon="exclamation-triangle">
                <flux:callout.heading>Error</flux:callout.heading>
                    <flux:callout.text>
                        <ol class="list-decimal text-xs">
                            @foreach ($errors->all() as $error)
                                <li>
                                    {{ $error }}
                                </li>
                            @endforeach
                        </ol>
                    </flux:callout.text>
            </flux:callout>
        @endif
        <form wire:submit="updateProfileInformation" class="my-6 w-full space-y-6">
            <div class="space-y-6">
                <div class="grid md:grid-cols-2 gap-4">
                    <flux:input :invalid="$errors->first('first_name')" wire:model="input.first_name" type="text" variant="floating" name="first_name" :label="__('user.label.first-name')"
                    autofocus autocomplete="first_name" placeholder="{{ __('user.ph.first-name') }}" />
                    <flux:input :invalid="$errors->first('last_name')" wire:model="input.last_name" type="text" variant="floating" name="last_name" :label="__('user.label.last-name')"
                        autofocus autocomplete="last_name" placeholder="{{ __('user.ph.last-name') }}" />
                </div>

                <div class="grid md:grid-cols-2 gap-4">
                    <!--Gender-->
                    <flux:select :invalid="$errors->first('gender')" wire:model="input.gender" name="gender" variant="floating" :label="__('customer.label.gender')">
                        <flux:select.option value="">{{ trans('customer.ph.select-gender') }}
                        </flux:select.option>
                        <flux:select.option value="male">{{ trans('customer.ph.male') }}
                        </flux:select.option>
                        <flux:select.option value="female">{{ trans('customer.ph.female') }}
                        </flux:select.option>
                    </flux:select>

                    <!--DOB-->
                    <flux:input :invalid="$errors->first('dob')" wire:model="input.dob" type="date" max="2010-12-31" variant="floating" name="dob" :label="__('customer.label.dob')"/>
                </div>
                <div class="grid md:grid-cols-2 gap-4">
                    <flux:input :invalid="$errors->first('nin')" wire:model="input.nin" type="text" variant="floating" name="last_name" :label="__('customer.label.nin')"
                        autofocus autocomplete="nin" placeholder="{{ __('customer.label.nin') }}" />
                </div>


            <flux:textarea wire:model="input.bio" :label="__('customer.label.bio')" type="text"
                autocomplete="bio" />

            <div class="flex items-center gap-4">
                <div class="flex items-center justify-end">
                    <flux:button variant="primary" type="submit" class="w-full">{{ __('Save') }}</flux:button>
                </div>

                <x-action-message class="me-3" on="profile-updated">
                    {{ __('Saved.') }}
                </x-action-message>
            </div>
            </div>
        </form>


    </x-settings.layout>
</section>
