<?php

use Illuminate\Support\Facades\Route;
use App\Livewire\Admin\Dashboard;
use App\Livewire\Settings\DeleteAccount;

Route::middleware(['auth', 'role:admin'])->group(function () {
    Route::get('update', App\Livewire\Update::class)->name('update');
});

Route::middleware(['auth', 'role:admin|technitian|teller', 'appIsntalled', 'checkVersion'])->group(function () {
    Route::get('dashboard', Dashboard::class)->name('dashboard');
    Route::get('settings/delete-account', DeleteAccount::class)->name('settings.deleteAccount');

    Route::middleware(['role_or_permission:admin|customers management'])->group(function () {
        Route::get('customers', App\Livewire\Admin\Customers\CustomersManagement::class)->name('customers.management');
        Route::get('deleted-customers', App\Livewire\Admin\Customers\DeletedCustomersManagement::class)->name('deletedCustomers.management');
        Route::get('customers-paket', App\Livewire\Admin\Customers\CustomerPaketManagement::class)->name('customers.paket.management');
        Route::get('deleted-customer-pakets', App\Livewire\Admin\Customers\DeletedCustomerPaketManagement::class)->name('deletedCustomers.paket.management');
        Route::get('/customer/{user}/show', App\Livewire\Admin\Customers\ShowCustomer::class)->name('customer.show');
    });
    //Route::get('/customer/{user}/show-billing', App\Livewire\Admin\Customers\ShowBillingCustomer::class)->name('customer.billing');

    Route::middleware(['role_or_permission:admin|pakets management'])->name('pakets.')->prefix('pakets')->group(function () {
        Route::get('/', App\Livewire\Admin\Pakets\PaketList::class)->name('management');
        Route::get('deleted-pakets', App\Livewire\Admin\Pakets\DeletedPaket::class)->name('deleted');
        Route::get('profile', [App\Livewire\Admin\Pakets\ProfileList::class, '__invoke'])->name('profile.management');
    });

    Route::middleware(['role_or_permission:admin|invoices management'])->name('billings.')->prefix('billings')->group(function () {
        Route::get('/', App\Livewire\Admin\Billings\BillingManagement::class)->name('management');
        Route::get('payment-management', App\Livewire\Admin\Billings\Payments\PaymentManagement::class)->name('management.payments');
        Route::get('{invoice}/show', App\Livewire\Admin\Billings\ShowBilling::class)->name('management.show-billing');
        Route::get('tellers', App\Livewire\Admin\Billings\Payments\Teller::class)->name('management.tellers');
        Route::get('/customer/{user}/show', App\Livewire\Admin\Customers\ShowBillingCustomer::class)->name('customer.billing');
    });

    Route::middleware(['role_or_permission:admin|configurations management'])->name('managements.')->prefix('managements')->group(function () {
        Route::middleware(['role_or_permission:admin|mikrotiks management'])->group(function () {
            Route::get('mikrotiks', App\Livewire\Admin\Mikrotiks\MikrotiksManagement::class)->name('mikrotiks');
            Route::get('deleted-mikrotiks', App\Livewire\Admin\Mikrotiks\DeletedMikrotiksManagement::class)->name('mikrotiks.deleted');
        });
        Route::get('users', App\Livewire\Admin\Users\UsersManagement::class)->name('users');
        Route::get('roles', App\Livewire\Admin\Roles\RolesManagement::class)->middleware(['role_or_permission:admin|roles management|permissions management'])->name('roles');
        Route::get('general', App\Livewire\Admin\Settings\General::class)->name('websystem');
        Route::get('autoisolir', App\Livewire\Admin\Settings\AutoIsolir::class)->name('autoisolirs');
        Route::get('mwan-monitoring', App\Livewire\Admin\Settings\WanMonitoring::class)->name('wanMonitorings');
        Route::get('webhook-monitoring', App\Livewire\Admin\Settings\WebhookMonitoring::class)->name('webhookMonitorings');

        Route::name('mikrotik.')->prefix('mikrotik')->group(function () {
            Route::get('{mikrotik}', App\Livewire\Admin\Mikrotiks\View\MikrotikDashboard::class)->name('dashboard');
            Route::get('{mikrotik}/profiles', App\Livewire\Admin\Mikrotiks\View\MikrotikProfiles::class)->name('profiles');
            Route::get('{mikrotik}/secrets', App\Livewire\Admin\Mikrotiks\View\MikrotikUserSecrets::class)->name('secrets');
            Route::get('{mikrotik}/pakets', App\Livewire\Admin\Mikrotiks\View\MikrotikPakets::class)->name('pakets');
            Route::get('{mikrotik}/customer', App\Livewire\Admin\Mikrotiks\View\MikrotikCustomer::class)->name('customers');
            Route::get('{mikrotik}/wan-monitoring', App\Livewire\Admin\Mikrotiks\View\WanMonitoring::class)->name('wanmonitoring');
            Route::get('{mikrotik}/user-monitoring', App\Livewire\Admin\Mikrotiks\View\MikrotikUserMonitoring::class)->name('usermonitoring');
        });
        Route::get('hotspots', App\Livewire\Admin\Hotspots\HotspotManagement::class)->name('hotspots');
        Route::get('payment-gateway', App\Livewire\Admin\Settings\PaymentGatewayManagement::class)->name('paymentgateways');

        Route::get('banks', App\Livewire\Admin\Settings\Banks\BankManagement::class)->name('banks');

        //Whatsapp Gateway Route
        Route::get('whatsapp-gateway', App\Livewire\Admin\WhatsappGateway\WhatsappGatewayManagement::class)->name('whatsapp_gateway');
        Route::get('whatsapp/number', App\Livewire\Admin\WhatsappGateway\Device::class)->name('whatsapp.number');
        Route::get('whatsapp/message-histories', App\Livewire\Admin\WhatsappGateway\MessageHistories::class)->name('whatsapp.messageHistories');
        Route::get('whatsapp/notification-message', App\Livewire\Admin\WhatsappGateway\NotificationMessageController::class)->name('whatsapp.notificationMessage');
        Route::get('whatsapp/boot-message', App\Livewire\Admin\WhatsappGateway\BootMessageController::class)->name('whatsapp.bootMessage');
        Route::get('whatsapp/invoices', App\Livewire\Admin\WhatsappGateway\InvoiceManagement::class)->name('whatsapp.invoice');
        Route::get('whatsapp/account-settings', App\Livewire\Admin\WhatsappGateway\AccountSettings::class)->name('whatsapp.settings-user-account');
        Route::get('whatsapp/company-settings', App\Livewire\Admin\WhatsappGateway\CompanySettings::class)->name('whatsapp.settings-user-company');

        Route::name('address.')->prefix('address')->group(function () {
            Route::get('list', App\Livewire\Admin\Settings\Address\AddressList::class)->name('list');
        });
    });
});
