<?php

use App\Http\Controllers\Auth\VerifyEmailController;
use App\Livewire\Auth\ConfirmPassword;
use App\Livewire\Auth\ForgotPassword;
use App\Livewire\Auth\Login;
use App\Livewire\Auth\Register;
use App\Livewire\Auth\ResetPassword;
use App\Livewire\Auth\VerifyEmail;
use Illuminate\Support\Facades\Route;

Route::middleware(['appIsntalled'])->group(function () {
    Route::middleware('guest')->group(function () {
        Route::get('login', Login::class)->name('login');
        //Route::get('register', Register::class)->name('register');

        Route::get('register', \App\Livewire\Auth\Register\RegisterStepOne::class)->name('register');
        Route::get('register-step-two', \App\Livewire\Auth\Register\RegisterStepTwo::class)->name('register.steptwo');
        Route::get('register-step-three', \App\Livewire\Auth\Register\RegisterStepThree::class)->name('register.stepthree');

        Route::get('forgot-password', ForgotPassword::class)->name('password.request');
        Route::get('reset-password/{token}', ResetPassword::class)->name('password.reset');
    });

    Route::middleware('auth')->group(function () {
        Route::get('verify-email', VerifyEmail::class)
            ->name('verification.notice');

        Route::get('verify-email/{id}/{hash}', VerifyEmailController::class)
            ->middleware(['signed', 'throttle:6,1'])
            ->name('verification.verify');

        Route::get('confirm-password', ConfirmPassword::class)
            ->name('password.confirm');
    });

    Route::post('logout', App\Livewire\Actions\Logout::class)
        ->name('logout');
});
