<?php

use Illuminate\Support\Facades\Route;

Route::middleware(['auth', 'role:admin|technitian', 'appIsntalled', 'checkVersion'])->group(function () {
    Route::name('helps.')->prefix('helps')->group(function () {
        Route::get('home', App\Livewire\Admin\Help\Index::class)->name('home');
        Route::get('general-setting', App\Livewire\Admin\Help\WebSystem\GeneralSetting::class)->name('generalSetting');
        Route::get('development', App\Livewire\Admin\Help\Development::class)->name('development');
        Route::name('servers.')->prefix('servers')->group(function () {
            Route::get('mikrotik', App\Livewire\Admin\Help\Servers\Mikrotik::class)->name('mikrotik');
            Route::get('add-mikrotik', App\Livewire\Admin\Help\Servers\AddMikrotik::class)->name('addMikrotik');
            Route::get('edit-mikrotik', App\Livewire\Admin\Help\Servers\EditMikrotik::class)->name('editMikrotik');
            Route::get('delete-mikrotik', App\Livewire\Admin\Help\Servers\DeleteMikrotik::class)->name('deleteMikrotik');
            Route::get('import-customer', App\Livewire\Admin\Help\Servers\ImportCustomer::class)->name('importCustomer');
            Route::get('import-profile', App\Livewire\Admin\Help\Servers\ImportProfile::class)->name('importProfile');
        });
        Route::name('customers.')->prefix('customers')->group(function () {
            Route::get('customer', App\Livewire\Admin\Help\Customers\Customer::class)->name('customer');
            Route::get('add', App\Livewire\Admin\Help\Customers\AddCustomer::class)->name('add');
            Route::get('delete', App\Livewire\Admin\Help\Customers\DeleteCustomer::class)->name('delete');
            Route::name('pakets.')->prefix('pakets')->group(function () {
                Route::get('paket', App\Livewire\Admin\Help\Customers\CustomerPakets\Paket::class)->name('paket');
                Route::get('add', App\Livewire\Admin\Help\Customers\CustomerPakets\AddCustomerPaket::class)->name('add');
                Route::get('edit', App\Livewire\Admin\Help\Customers\CustomerPakets\EditCustomerPaket::class)->name('edit');
                Route::get('delete', App\Livewire\Admin\Help\Customers\CustomerPakets\DeleteCustomerPaket::class)->name('delete');
            });
        });

        Route::name('whatsapps.')->prefix('whatsapp-gateway')->group(function () {
            Route::get('register', App\Livewire\Admin\Help\WhatsappGateway\Register::class)->name('register');
            Route::get('general-config', App\Livewire\Admin\Help\WhatsappGateway\GeneralConfiguration::class)->name('generalConfig');
            Route::get('add-device', App\Livewire\Admin\Help\WhatsappGateway\AddDevice::class)->name('addDevice');
            Route::get('delete-device', App\Livewire\Admin\Help\WhatsappGateway\DeleteDevice::class)->name('deleteDevice');
            Route::get('scan-device', App\Livewire\Admin\Help\WhatsappGateway\ScanDevice::class)->name('scanDevice');
            Route::get('notification-message', App\Livewire\Admin\Help\WhatsappGateway\NotificationMessage::class)->name('notificationMessage');
            Route::get('edit-notification-message', App\Livewire\Admin\Help\WhatsappGateway\EditNotificationMessage::class)->name('editNotificationMessage');
            Route::get('payment-notification-message', App\Livewire\Admin\Help\WhatsappGateway\PaymentNotificationMessage::class)->name('paymentNotificationMessage');
            Route::get('unpayment-notification-message', App\Livewire\Admin\Help\WhatsappGateway\UnpaymentNotificationMessage::class)->name('unpaymentNotificationMessage');
            Route::get('paylater-notification-message', App\Livewire\Admin\Help\WhatsappGateway\PaylaterNotificationMessage::class)->name('paylaterNotificationMessage');
            Route::get('warning-bill-notification-message', App\Livewire\Admin\Help\WhatsappGateway\WarningBillNotificationMessage::class)->name('warningBillNotificationMessage');
            Route::get('deadline-bill-notification-message', App\Livewire\Admin\Help\WhatsappGateway\DeadlineBillNotificationMessage::class)->name('deadlineBillNotificationMessage');
            Route::get('isolir-notification-message', App\Livewire\Admin\Help\WhatsappGateway\IsolirNotificationMessage::class)->name('isolirNotificationMessage');
            Route::get('keyword-message', App\Livewire\Admin\Help\WhatsappGateway\KeywordMessage::class)->name('keywordMessage');
            Route::get('payment', App\Livewire\Admin\Help\WhatsappGateway\Payment::class)->name('payment');
            Route::get('subscription', App\Livewire\Admin\Help\WhatsappGateway\Subscription::class)->name('subscription');
        });

        Route::name('paymentgateways.')->prefix('payment-gateway')->group(function () {
            Route::get('midtrans', App\Livewire\Admin\Help\PaymentGateway\Midtrans::class)->name('midtrans');
            Route::get('tripay', App\Livewire\Admin\Help\PaymentGateway\Tripay::class)->name('tripay');
        });

        Route::name('server-configuration.')->prefix('server-configuration')->group(function () {
            Route::get('aapanel', App\Livewire\Admin\Help\ServerConfiguration\Aapanel::class)->name('aapanel');
        });
    });
});
