<?php


use Illuminate\Http\Request;
use App\Livewire\Settings\Address;
use App\Livewire\Settings\Profile;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use App\Livewire\Settings\Appearance;
use Illuminate\Support\Facades\Route;
use App\Livewire\Settings\EditAccount;
use App\Livewire\Settings\EditPassword;
use Illuminate\Support\Facades\Storage;

//Route::get('test', \App\Livewire\Test::class)->name('test');


Route::get('install', App\Livewire\Install::class)->name('install');
Route::middleware(['appIsntalled'])->group(function () {
    Route::get('/', function () {
        if (Auth::user()) {
            if (Auth::user()->hasRole('admin') || Auth::user()->hasRole('technitian') || Auth::user()->hasRole('teller')) {
                return redirect()->route('dashboard');
            } else if (Auth::user()->hasRole('customer')) {
                return redirect()->route('customer.dashboard');
            }
        } else {
            if (env('APP_INSTALLED') === false) {
                return redirect()->route('install');
            }
            return view('welcome');
        }
    })->name('home');
    Route::name('pages.')->prefix('pages')->group(function () {
        Route::get('term-of-service', App\Livewire\Pages\TermOfService::class)->name('tos');
        Route::get('privacy', App\Livewire\Pages\Privacy::class)->name('privacy');
        Route::get('contact', App\Livewire\Pages\Contact::class)->name('contact');
    });

    Route::webhooks('whatsapp/webhook', 'whatsapp-gateway');
    Route::webhooks('mikrotik/webhook', 'mikrotik');
    Route::webhooks('tripay/response', 'tripay');
    //Route::post('tripay/response', App\Http\Controllers\TripayController::class)->name('tripay');

    //Route::middleware(['auth', 'role:admin|technitian'])->group(function () {
    Route::middleware(['auth'])->group(function () {
        Route::redirect('settings', 'settings/profile');
        Route::get('settings/profile', Profile::class)->name('settings.profile');
        Route::get('settings/address', Address::class)->name('settings.address');
        Route::get('settings/appearance', Appearance::class)->name('settings.appearance');
        Route::get('settings/account', EditAccount::class)->name('settings.account');
        Route::get('settings/password', EditPassword::class)->name('settings.password');
    });


    Route::middleware(['auth', 'role:customer'])->name('customer.')->prefix('customer')->group(function () {
        Route::get('dashboard', App\Livewire\Customer\Dashboard::class)->name('dashboard');
        Route::get('payment-management', App\Livewire\Customer\Billing\PaymentManagement::class)->name('paymentmanagement');
        Route::get('subscription-management', App\Livewire\Customer\Subscription\SubscriptionManagement::class)->name('subscriptionmanagement');
    });


    Route::get('files/download/{path}', function (string $path, Request $request) {
        // Log::info($request->hasValidSignature());
        //  if (! $request->hasValidSignature()) {
        //      abort(401);
        //  }
        if (!Storage::disk('invoice_files')->exists($path)) return abort(404, 'File not found!');
        return Storage::disk('invoice_files')->download($path);
        //return dd('Download');
    })->name('files.download');
});

//Customer Route
//Route::middleware(['auth'])->name('customer.')->prefix('customer')->group(function () {});

require __DIR__ . '/auth.php';
require __DIR__ . '/help.php';
require __DIR__ . '/admin.php';
